
| Problem             | GP           | GP+DVO       | Speedup     | GP+DVO+FC    | Speedup     |
|---------------------|--------------|--------------|-------------|--------------|-------------|
| Huge-fact (18/18)   | 5.3(5181K)   | 2.26 (1411K) | 2.3x(3.6x)  | 3.59 (1024K) | 1.47x(5x)   |
| BW-Large-B (18/18)  | 4.15(2823K)  | 3.14(1416K)  | 1.3x(2x)    | 4.78(949K)   | .86(3x)     |
| Rocket-ext-a (7/36) | 19.43(8128K) | 14.9(5252K)  | 1.3x(1.5x)  | 14.5(1877K)  | 1.3x(4.3x)  |
| Rocket-ext-b (7/36) | 14.1(10434K) | 7.91(4382K)  | 1.8x(2.4x)  | 6(1490K)     | 2.4x(7x)    |
| Att-log-a(11/79)    | 10hr         | 10hr         | -           | 10hr.        |             |
| Gripper-6(11/17)    | 1.1(2802K)   | .65(1107K)   | 1.7x(2.5x)  | .73 (740K)   | 1.5x(3.7x)  |
| Tsp-10(10/10)       | 89(69974K)   | 78(37654K)   | 1.14x(1.9x) | 81(14697K)   | 1.09x(4.8x) |
| Tower-6(63/63)      | 10hr         | 10hr         | -           | 10hr.        |             |

Table 4: Impact of forward checking and dynamic variable ordering routines on Graphplan. Times are in cpu minutes as measured on a 500 MHZ Pentium-III running Linux and Franz Allegro Common Lisp 5. The numbers in parentheses next to times are the number of backtracks. The speedup columns report two factors–the first is the speedup in time, and the second is the speedup in terms of number of backtracks. While FC and DVO tend to reduce the number of backtracks, the reduction does not always seem to show up in the time savings.

reduce number of backtracks from 69974K to 14697K, a 4.8x improvement. However, this pales in comparison to 2232K backtracks (or 31x improvement) given by by EBL/DDB (see the entry in Table 1). Notice that these results only say that variable ordering strategies do not make a dramatic difference for Graphplan's backward search (or a DCSP compilation of the planning graph); they do not make any claims about the utility of FC and DVO for a CSP compilation of the planning graph.

## 7.1 Complementing Ebl/Ddb With Forward Checking And Dynamic Variable Ordering

Although forward checking and dynamic variable ordering approaches were not found to be particularly effective in isolation for Graphplan's backward search, I thought that it would be interesting to revisit them in the context of a Graphplan enhanced with EBL/DDB strategies. Part of the original reasoning underlying the expectation that goal (variable) ordering will not have a significant effect on Graphplan performance is based on the fact that all the failing goal sets are stored in-toto as memos (Blum & Furst, 1997, pp. 290). This reason no longer holds when we use EBL/DDB.

Further more, there exists some difference of opinion as to whether or not forward checking and DDB can fruitfully co-exist. The results of (Prosser, 1993) suggest that domain-filtering–such as the one afforded by forward checking, degrades intelligent backtracking. The more recent work
(Frost & Dechter, 1994; Bayardo & Schrag, 1997) however seems to suggest however that best CSP
algorithms should have both capabilities.

While adding plain DVO capability on top of EBL/DDB presents no difficulties, adding forward checking does require some changes to the algorithm in Figure 4. The difficulty arises because a failure may have occurred as a combined effect of the forward checking and backtracking. For example, suppose we have four variables v1    v4 that are being considered for assignment in that order. Suppose v3 has the domain ; 2; 3 , and v3 cannot be if v1 is a, and cannot be 2 if v2 is b. Suppose further that v4's domain only contains d, and there is a constraint saying that v4 can't