
| Problem      | EBL         | EBL+DVO     | EBL+FC+DVO   |             |             |
|--------------|-------------|-------------|--------------|-------------|-------------|
| Time(btks)   | Time(btks)  | Speedup     | Time(Btks)   | Speedup     |             |
| Huge-fct     | 3.08(2004K) | 1.51(745K)  | 2x(2.68x)    | 2.57(404K)  | 1.2x(5x)    |
| BW-Large-B   | 2.27(798K)  | 1.81(514K)  | 1.25x(1.6x)  | 2.98(333K)  | .76x(2.39x) |
| Rocket-ext-a | .8(764K)    | .4(242K)    | 2x(3.2x)     | .73(273K)   | 1.09x(2.8x) |
| Rocket-ext-b | .8(569K)    | .29(151K)   | 2.75x(3.76x) | .72(195K)   | 1.1x(2.9x)  |
| Att-log-a    | 1.97(2186K) | 2.59(1109K) | .76x(1.97x)  | 3.98(1134K) | .5x(1.92x)  |
| Tower-6      | 2.53(4098K) | 3.78(3396K) | .67x(1.2x)   | 2.09(636K)  | 1.2x(6.4x)  |
| TSP-10       | .99(2232K)  | 1.27(1793K) | .77x(1.24x)  | 1.34(828K)  | .73x(2.7x)  |

Table 5: Effect of complementing EBL/DDB with dynamic variable ordering and forward checking strategies. The speedup columns report two factors–the first is the speedup in time, and the second is the speedup in terms of number of backtracks. While FC and DVO tend to reduce the number of backtracks, the reduction does not always seem to show up in the time savings.

be d if v1 is a and v3 is 3. Suppose we are using forward checking, and have assigned v1; v2 the values a and b. Forward checking prunes and 2 from v3's domain, leaving only the value 3. At this point, we try to assign v4 and fail. If we use the algorithm in Figure 4, the conflict set for v4 would be v4; v3; v1 , as the constraint that is violated is v1 a v3 3 v4 d. However this is not sufficient since the failure at v4 may not have occurred if forward checking had not stripped the value 2 from the domain of v3. This problem can be handled by pushing v1 and v2, the variables whose assignment stripped some values from v3, into v3's conflict set.20 Specifically, the conflict set of every variable v is initialized to v to begin with, and whenever v loses a value during forward checking with respect to the assignment of v 0
, v 0 is added to the conflict set of v. Whenever a future variable (such as v4) conflicts with v3, we add the conflict set of v3 (rather than just v3) to the conflict set of v4. Specifically the line
"Set cs = cs l "
in the procedure in Figure 4 is replaced with the line

## "Set Cs = Cs Conflict-Set(L)"

I have incorporated the above changes into my implementation, so it can support support forward checking, dynamic variable ordering as well as EBL on Graphplan. Table 5 shows the performance of this version on the experimental test suite. As can be seen from the numbers, the number of backtracks are reduced by up to 3.7x in the case of EBL+DVO, and up to 5x in the case of EBL+FC+DVO. The cpu time improvements are somewhat lower. While we got up to 2.7x speedup