To check if my intuitions about the effectiveness of EBL/DDB in randomized search were indeed correct, I conducted an empirical investigation comparing the performance of random search on standard Graphplan as well as Graphplan with EBL/DDB capabilities. Since the search is randomized, each problem is solved multiple number of times (100 times in most cases), and the runtime, plan length and other statistics were averaged over all the runs. The experiments are conducted with a given backtrack limit, a given restart limit, as well as a limit on the number of levels to which the planning graph is extended. This last one is needed as in randomized search, a solution may be missed at the first level it appears, leading to a prolonged extension of the planning graph until a (inoptimal) solution is found at a later level. When the limit on the number of levels is expanded, the probability of finding solution increases, but at the same time, the cpu time spent searching the graph also increases.

Having implemented this random restart search, the first thing I noticed is an improvement in the solvability horizon (as expected, given the results in (Gomes et al., 1998)). Table 6 shows these results. One important point to note is that the results in the table above talk about *average* plan lengths and cpu times. This is needed as due to randomization potentially each run can produce a different outcome (plan). Secondly, while Graphplan with systematic search guarantees shortest plans (measured in the number of steps), the randomized search will not have such a guarantee.

In particular, the randomized version might consider a particular planning graph to be barren of solutions, based simply on the fact that no solution could be found within the confines of the given backtrack limit and number of restarts.

Graphplan, with or without EBL/DDB, is more likely to solve larger problems with randomized search strategies. For example, in the logistics domain, only the Att-log-a problem was solvable
(within 24 hours real time) with EBL and systematic search. With the randomization added, my implementation was able to solve both Att-log-b and Att-log-c quite frequently. As the limits on the number of restarts, backtracks and levels is increased, the likelihood of finding a solution as well as the average length of the solution found improves. For example, Graphplan with EBL/DDB is able to solve Att-log-b in every trial for 10 restarts, 100 backtracks and 30 levels as the limits (although the plans are quite inoptimal).

The next, and perhaps more interesting, question I wanted to investigate is whether EBL and DDB will continue to be useful for Graphplan when it uses randomized search. At first blush, it seems as if they will not be as important–after all even Graphplan with standard search may luck out and be able to find solutions quickly in the presence of randomization. Further thought however suggests that EBL and DDB may still be able to help Graphplan. Specifically, they can help Graphplan in using the given backtrack limit in a more judicious fashion. To elaborate, suppose the random restart search is being conducted with 100 backtracks and 10 restarts. With EBL and DDB, Graphplan is able to pinpoint the cause of the failure more accurately than without EBL and DDB. This means that when the search backtracks, the chance that it will have to backtrack again for the same (or similar) reasons is reduced. This in turn gives the search more of a chance on catching a success during one of the number of epochs allowed. All this is in addition to the more direct benefit of being able to use the stored memos across epochs to cut down search.

As can be seen from the data in Table 6, for a given set of limits on number of restarts, number of backtracks, and number of levels expanded, Graphplan with EBL/DDB is able to get a higher percentage of solvability as well as significantly shorter length solutions (both in terms of levels and in terms of actions). To get comparable results on the standard Graphplan, I had to significantly increase the input parameters (restarts, backtracks and levels expanded), which in turn led to dra-