The general importance of EBL & DDB for CSP and SAT problems is well recognized. Indeed, one of the best systematic solvers for propositional satisfiability problems is RELSAT (Bayardo &
Schrag, 1997), which uses EBL, DDB, and forward checking. A randomized version of RELSAT is one of the solvers supported by the BLACKBOX system (Kautz & Selman, 1999), which compiles the planning graph into a SAT encoding, and ships it to various solvers. BLACKBOX thus offers a way of indirectly comparing the Dynamic CSP and static CSP models for solving the planning graph. As discussed in Section 2.2, the main differences are that BLACKBOX needs to compile the planning graph into an extensional SAT representation. This makes it harder for BLACKBOX to exploit the results of searches in previous levels (as Graphplan does with its stored memos),
and also leads to memory blowups. The latter is particularly problematic as the techniques for condensing planning graphs, such as the bi-level representation discussed in (Fox & Long, 1999; Smith & Weld, 1999) will not be effective when we compile the planning graph to SAT. On the flip side, BLACKBOX allows non-directional search, and the opportunity to exploit existing SAT
solvers, rather than develop customized solvers for the planning graph. At present, it is not clear whether either of these approaches dominates the other. In my own informal experiments, I found that certain problems, such as Att-log-x, are easier to solve with non-directional search offered by BLACKBOX, while others, such as Gripper-x, are easier to solve with the Graphplan backward search. The results of the recent AIPS planning competition are also inconclusive in this respect
(McDermott, 1998).

While my main rationale for focusing on dynamic CSP model of the planning graph is due to its closeness to Graphplan's backward search, Gelle (1998) argues that keeping activity constraints distinct from value constraints has several advantages in terms of modularity of the representation.

In Graphplan, this advantage becomes apparent when not all activation constraints are known a priori, but are posted dynamically during search,. This is the case in several extensions of the Graphplan algorithm that handle conditional effects (Kambhampati et al., 1997; Anderson, Smith,
& Weld, 1998; Koehler et al., 1997), and incomplete initial states (Weld, Anderson, & Smith, 1998).

Although EBL and DDB strategies try to exploit the symmetry in the search space to improve the search performance, they do not go far enough in many cases. For example, in the Gripper domain, the real difficulty is that search gets lost in the combinatorics of deciding which hand should be used to pick which ball for transfer into the next room–a decision which is completely irrelevant for the quality of the solution (or the search failures, for that matter). While EBL/DDB allow Graphplan to cut the search down a bit, allowing transfer of up to 10 balls from one room to another, they are over come beyond 10 balls. There are two possible ways of scaling further. The first is to
"variablize" memos, and realize that certain types of failures would have occurred irrespective of the actual identity of the hand that is used. Variablization, also called "generalization" is a part of EBL methods (Kambhampati, 1998; Kambhampati et al., 1997). Another way of scaling up in such situations would be to recognize the symmetry inherent in the problem and abstract the resources from the search. In (Srivastava & Kambhampati, 1999), we describe this type of resource abstraction approach for Graphplan.

## 10. Conclusion And Future Work

In this paper, I traced the connections between the Graphplan planning graph and CSP, and motivated the need for exploiting CSP techniques to improve the performance of Graphplan backward search. I then adapted and evaluated several CSP search techniques in the contest of Graph-