plan. These included EBL, DDB, forward checking, dynamic variable ordering, sticky values, and random-restart search. My empirical studies show the EBL/DDB is particularly useful in dramatically speeding up Graphplan's backward search (by up tp 1000x in some instances). The speedups can be improved further (by up to 8x) with the addition of forward checking, dynamic variable ordering and sticky values on top of EBL/DDB. I also showed that EBL/DDB techniques are equally effective in helping Graphplan, even if random-restart search strategies are used.

A secondary contribution of this paper is a clear description of the connections between the Graphplan planning graph, and the (dynamic) constraint satisfaction problem. These connections help us understand some unique properties of the Graphplan memoization strategy, when viewed from CSP standpoint (see Section 9).

There are several possible ways of extending this work. The first would be to support the use of learned memos across problems (or when the specification of a problem changes, as is the case during replanning). Blum & Furst (1997) suggest this as a promising future direction, and the EBL framework described here makes the extension feasible. As discussed in (Kambhampati, 1998; Schiex & Verfaillie, 1993), supporting such inter-problem usage involves "contextualizing" the learned no-goods. In particular, since the soundness of memos depends only on the initial state of the problem (given that operators do not change from problem to problem), inter-problem usage of memos can be supported by tagging each learned memo with the specific initial state literals that supported that memo. Memos can then be used at the corresponding level of a new problem as long as their initial state justification holds in the new problem. The initial state justification for the memos can be computed incrementally by a procedure that first justifies the propagated mutex relations in terms of the initial state, and then justifies individual memos in terms of the justifications of the mutexes and other memos from which they are derived.

The success of EBL/DDB approaches in Graphplan is in part due to the high degree of redundancy in the planning graph structure. For example, the propositions (actions) at level l in a planning graph are a superset of the propositions (actions) at level l , the mutexes (memos) at level l are a subset of the mutexes (memos) at level l ). While the EBL/DDB techniques help Graphplan exploit some of this redundancy by avoiding previous failures, the exploitation of redundancy can be pushed further. Indeed, the search that Graphplan does on a planning graph of size l is almost a *re-play* of the search it did on the planning graph of size l (with a few additional choices). In (Zimmerman & Kambhampati, 1999), we present a complementary technique called
"explanation-guided backward search" that attempts to exploit this *deja vu* property of the Graphplan's backward search. Our technique involves keeping track of an elaborate trace of the search at a level l (along with the failure information), termed the "pilot explanation" for level l, and using the pilot explanation to guide the search at level l . The way EBL/DDB help in this process is that they significantly reduce the size of the pilot explanations that need to be maintained. Preliminary results with this technique shows that it complements EBL/DDB and provides significant further savings in search.

## Acknowledgements

This research is supported in part by NSF young investigator award (NYI) IRI-9457634, ARPA/Rome Laboratory planning initiative grant F30602-95-C-0247, Army AASERT grant DAAH04-96-10247, AFOSR grant F20602-98-1-0182 and NSF grant IRI-9801676. I thank Maria Fox and Derek Long for taking the time to implement and experiment with EBL/DDB on their STAN system. I