
## 2.3 Interpreting Mutex Propagation From The Csp View

Viewing the planning graph as a constraint satisfaction problem helps put the mutex propagation in a clearer perspective (see (Kambhampati et al., 1997)). Specifically, the way Graphplan constructs its planning graph, it winds up enforcing partial directed 1-consistency and partial directed 2-consistency (Tsang, 1993). The partial 1-consistency is ensured by the graph building procedure which introduces an action at level l only if the actions preconditions are present in the proposition list at level l and are not mutually exclusive. Partial 2-consistency is ensured by the mutual exclusion propagation procedure.

In particular, the Graphplan planning graph construction implicitly derives "no-good"5constraints of the form:

```
                              Active P i
                                      m or P i
                                               m
                                                
In which case P i
             m will be simply removed from (or will not be put into) the level i, and the mutex
constraints of the form:
                   
                    Active P i
                            m Active P i
                                         n
                                          
                                               or P i
                                                   m P i
                                                           n
                                                            

```

$$\left(A c t i v e\ P_{m}^{i}\ \ \ \ \ A c t i v e\ P_{n}^{i}\ \right)\ \ \ \ o r\ P_{m}^{i}$$

in which case P i m and P i n are marked mutually exclusive.

Both procedures are "directed" in that they only use "reachability" analysis in enforcing the consistency, and are "partial" in that they do not enforce either full 1-consistency or full 2-consistency.

Lack of full 1-consistency is verified by the fact that the appearance of a goal at level k does not necessarily mean that the goal is actually achievable by level k (i.e., there is a solution for the CSP
that assigns a non- value to that goal at that level). Similarly, lack of full 2-consistency is verified by the fact that appearance of a pair of goals at level k does not imply that there is a plan for achieving both goals by that level.

There is another, somewhat less obvious, way in which the consistency enforcement used in Graphplan is partial (and very conservative)–it concentrates only on whether a single goal variable or a pair of goal variables can simultaneously have non- values (be active) in a solution. It may be that a goal can have a non- value, but not all non- values are feasible. Similarly, it may be that a pair of goals are achievable, but not necessarily achievable with every possible pair of actions in their respective domains.

This interpretation of mutex propagation procedure in Graphplan brings to fore several possible extensions worth considering for Graphplan:
1. Explore the utility of directional consistency enforcement procedures that are not based solely on reachability analysis. Kambhampati *et. al.* (1997) argue for extending this analysis using relevance information, and Do *et. al.* (2000) provide an empirical analysis of the effectiveness of consistency enforcement through relevance information.

2. Explore the utility of enforcing higher level consistency. As pointed out in (Kambhampati et al., 1997; Kambhampati, 1998), the memoization strategies can be seen as failure-driven procedures that incrementally enforce partial higher level consistency.
7