# Value-Function Approximations For Partially Observable Markov  Decision  Processes

## Milos  Hauskrecht

MILOS@CS.BROWN.EDU
Computer Science Department, Brown University Box 1910, Brown University, Providence, RI 02912, USA

## Abstract

Partially observable Markov decision processes (POMDPs) provide an elegant mathematical framework for modeling complex decision and planning problems in stochastic domains in which states of the system are observable only indirectly, via a set of imperfect or noisy observations. The modeling advantage of POMDPs, however, comes at a price —
exact methods for solving them are computationally very expensive and thus applicable in practice only to very simple problems. We focus on efficient approximation (heuristic)
methods that attempt to alleviate the computational problem and trade off accuracy for speed. We have two objectives here. First, we survey various approximation methods, analyze their properties and relations and provide some new insights into their differences.

Second, we present a number of new approximation methods and novel refinements of existing techniques. The theoretical results are supported by experiments on a problem from the agent navigation domain.

## 1. Introduction

Making decisions in dynamic environments requires careful evaluation of the cost and benefits not only of the immediate action but also of choices we may have in the future. This evaluation becomes harder when the effects of actions are stochastic, so that we must pursue and evaluate many possible outcomes in parallel. Typically, the problem becomes more complex the further we look into the future. The situation becomes even worse when the outcomes we can observe are imperfect or unreliable indicators of the underlying process and special actions are needed to obtain more reliable information. Unfortunately, many real-world decision problems fall into this category.

Consider, for example, a problem of patient management. The patient comes to the hospital with an initial set of complaints. Only rarely do these allow the physician (decisionmaker) to diagnose the underlying disease with certainty, so that a number of disease options generally remain open after the initial evaluation. The physician has multiple choices in managing the patient.  He/she can choose to do nothing (wait and see), order additional tests and learn more about the patient state and disease, or proceed to a more radical treatment
(e.g. surgery). Making the right decision is not an easy task. The disease the patient suffers can progress over time and may become worse if the window of opportunity for a particular effective treatment is missed. On the other hand, selection of the wrong treatment may make the patient's condition worse, or may prevent applying the correct treatment later.

The result of the treatment is typically non-deterministic and more outcomes are possible. In addition, both treatment and investigative choices come with different costs. Thus, in