Thus the value function is linear and can be computed efficiently by solving a system of linear equations.

Since in general the FSM controller can start from any memory state, we can always choose the initial memory state greedily, maximizing the expected value of the result. In such a case the optimal choice function ψ is defined as:

$$\psi(b)=\arg\operatorname*{max}_{x\in M}V^{C}(x,b),$$

and the value for the FSM policy C and belief state b is:

$$V^{C}(b)=\operatorname*{max}_{x\in M}V^{C}(x,b)=V^{C}(\psi(b),b).$$

Note that the resulting value function for the strategy C is piecewise linear and convex and represents expected rewards for following C . Since no strategy can perform better that the optimal strategy, V C ≤ V* must hold.

## 2.6.3 Policy Improvement

The policy-iteration method, searing the space of controllers, starts from an arbitrary initial policy and improves it gradually by refining its finite-state machine (FSM) description. In particular, one keeps modifying the structure of the controller by adding or removing controller states (memory) and transitions. Let C and C ′ be an old and a new FSM controller.

In the improvement step we must satisfy

$$\cdot^{C^{\dagger}}(b)\geq V$$

VC' ( b ) ≥ VC ( b ) for all b ∈ I;

## Ð E I Such That V C (B) > V C (B).

To guarantee the improvement, Hansen (1998a, 1998b) proposed a policy-iteration algorithm that relies on exact value function updates to obtain a new improved policy structure. 10  The basic idea of the improvement is based on the observation that one can switch back and forth between the FSM policy description and the piecewise-linear and convex representation of a value function. In particular:

- the value function for an FSM policy is piecewise-linear and convex and every linear function describing it corresponds to a memory state of a controller;
- individual linear functions comprising the new value function after an update can be viewed as new memory states of an FSM policy, as described in Section 2.5.3.
This allows us to improve the policy by adding new memory states corresponding to linear functions of the new value function obtained after the exact update. The technique can be refined by removing some of the linear functions (memory states) whenever they are fully dominated by one of the other linear functions.

10. A policy-iteration algorithm that exploits exact value function updates but works with policies defined