method. Thus, instead of searching the complete policy space, we can restrict our attention only to its subspace that we believe to contain the optimal solution or a good approximation. Memoryless policies (Platzman, 1977; White & Scherer, 1994; Littman, 1994; Singh, Jaakkola, & Jordan, 1994), policies based on truncated histories (Platzman, 1977; White & Scherer, 1994; McCallum, 1995), or finite-state controllers with a fixed number of memory states (Platzman, 1980; Hauskrecht, 1997; Hansen, 1998a, 1998b) are all examples of a policy-space restriction. In the following we consider only the finite-state machine model
(see Section 2.6.1), which is quite general; other models can be viewed as its special cases.

States of an FSM policy model represent the memory of the controller and, in general, summarize information about past activities and observations. Thus, they are best viewed as approximations of the information states, or as feature states. The transition model of the controller ( φ ) then approximates the update function of the information-state MDP ( t ) and the output function of an FSM ( η ) approximates the control function ( µ ) mapping information states to actions. The important property of the model, as shown Section 2.6.2, is that the value function for a fixed controller and fixed initial memory state can be obtained efficiently by solving a system of linear equations (Platzman, 1980).

To apply the policy approximation approach we first need to decide (1) how to restrict a space of policies and (2) how to judge the policy quality.

A restriction frequently used is to consider only controllers with a fixed number of states, say k .  Other structural restrictions further narrowing the space of policies can restrict either the output function (choice of actions at different controller states), or the transitions between the current and next states. In general, any heuristic or domain-related insight may help in selecting the right biases.

Two different policies can yield value functions that are better in different regions of the belief space. Thus, in order to decide which policy is the best, we need to define the importance of different regions and their combinations. There are multiple solutions to this.

For example, Platzman (1980) considers the worst-case measure and optimizes the worst (minimal) value for all initial belief states. Let C be a space of FSM controllers satisfying given restrictions. Then the quality of a policy under the worst case measure is:

## Max Min Max V C (X, B).

Another option is to consider a distribution over all initial belief states and maximize the expectation of their value function values. However, the most common objective is to choose the policy that leads to the best value for a single initial belief state bo:

## Max Max V C (X, Bo).

Finding the optimal policy for this case reduces to a combinatorial optimization problem.

Unfortunately, for all but trivial cases, even this problem is computationally intractable.

For example, the problem of finding the optimal policy for a memoryless case (only current observations are considered) is NP-hard (Littman, 1994). Thus, various heuristics are typically applied to alleviate this difficulty (Littman, 1994).