
## 4.4 Fixed-Strategy Approximations

A finite-state machine (FSM) model is used primarily to define a control strategy. Such a strategy does not require beliefstate updates since it directly maps sequences of observations to sequences of actions.  The value function of an FSM strategy is piecewise linear and convex and can be found efficiently in the number of memory states (Section 2.6.1). While in the policy iteration and policy approximation contexts the value function for a specific strategy is used to quantify the goodness of the policy in the first place, the value function alone can be also used as a substitute for the optimal value function. In this case, the value function

$$V^{C}(b)=\operatorname*{max}_{x\in M}V^{C}(x,b),$$

(defined over the belief space) equals where V C ( x, b ) = ∑ s ∈ S V C ( x, s ) b ( s ) is obtained by solving a set of | S || M | linear equations
(Section 2.6.2). As remarked earlier, the value for the fixed strategy lower-bounds the optimal value function, that is V C ≤ V *.

To simplify the comparison of the fixed-strategy approximation to other approximations, we can rewrite its solution also in terms of fixed-strategy updates

 $\large\hat{V}_{i+1}\big(b\big)\quad=\quad i$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  $$\large=\quad i$$  
$$\begin{array}{l}{{\operatorname*{max}_{x\in M}\left\{\sum_{s\in S}\rho(s,\eta(x))b(s)+\gamma\sum_{o\in\Theta}\sum_{s^{\prime}\in S}P(o,s^{\prime}|s,\eta(x))b(s)\alpha_{i}(\phi(x,o),s^{\prime})\right\},}}\\ {{\operatorname*{max}_{x\in M}\left\{\sum_{s\in S}b(s)\left[\rho(s,\eta(x))+\gamma\sum_{o\in\Theta,s^{\prime}\in S}P(o,s^{\prime}|s,\eta(x))\alpha_{i}(\phi(x,o),s^{\prime})\right]\right\}}}\\ {{\operatorname*{max}_{(H_{F\,S\,M}\hat{V}_{i})(b).}}}\end{array}$$
The value function V is piecewise linear and convex and consists of | M | linear functions α i ( x, . ).  For the infinite-horizon discounted case α i ( x, s) represents the ith approximation of V C ( x, s ). Note that the update can be applied to the finite-horizon case in a straightforward way.

## 4.4.1 Quality Of Control

Assume we have an FSM strategy and would like to use it as a substitute for the optimal control policy. There are three different ways in which we can use it to extract the control.

The first is to simply execute the strategy represented by the FSM. There is no need to update belief states in this case.  The second possibility is to choose linear functions corresponding to different memory states and their associated actions repeatedly in every step.  We refer to such a controller as a direct (DR) controller.  This approach requires updating of belief states in every step.  On the other hand its control performance is no worse than that of the FSM control. The final strategy discards all the information about actions and extracts the policy by using the value function V(b) and one-step lookahead. This method (LA) requires both belief state updates and lookaheads and leads to the worst reactive time. Like DR, however, this strategy is guaranteed to be no worse than the FSM controller. The following theorem relates the performances of the three controllers.