The key property of convex rules is that their corresponding grid-based update H G is a contraction in the max norm (Gordon, 1995). Thus, the approximate value iteration based on H G converges to the unique fixed-point solution. In addition, H G based on convex rules is isotone.

## 4.5.2 Examples Of Convex Rules

The family of convex rules includes approaches that are very commonly used in practice, like nearest neighbor, kern el regression, linear point interpolations and many others.

Take, for example, the nearest-neighbor approach. The function for a belief point b is estimated using the value at the grid point closest to it in terms of some distance metric M
defined over the beliefspace. Then, for any point b, there is exactly one nonzero parameter λ = 1 such that ‖ b − bf ‖ m ≤‖ b − bf ‖ m holds for all i = 1, 2, …, k. All other λ s are zero. Assuming the Euclidean distance metric, the nearest-neighbor approach leads to a piecewise constant approximation, in which regions with equal values correspond to regions with a common nearest grid point.

The nearest neighbor estimates the function value by taking into an account only one grid point and its value. Kernel regression expands upon this by using more grid points. It adds up and weights their contributions (values) according to their distance from the target point. For example, assuming Gaussian kernels, the weight for a grid point bf is

$$\lambda_{j}^{b}=\beta\exp^{-\|b-b_{j}^{G}\|_{M}^{2}/2\sigma^{2}},$$
$\left|\,\cap\right|$ . 
$$b=\sum_{j=1}^{|G|}\lambda_{j}^{b}b_{j}^{G}\,.$$

where β is a normalizing constant ensuring that ∑ j = 1 λ j = 1 and σ is a parameter that flattens or narrows weight functions. For the Euclidean metric, the above kernel-regression rule leads to a smooth approximation of the function.

Linear point interpolations are a subclass of convex rules that in addition to constraints in Definition 9 satisfy That is, a belief point b is a convex combination of grid points and the as are the corresponding coefficients. Because the optimal value function for the POMDP is convex, the new constraint is sufficient to prove the upper-bound property of the approximation. In general, there can be many different linear point-interpolations for a given grid. A challenging problem here is to find the rule with the best approximation. We discuss these issues in Section 4.5.7.

## 4.5.3 Conversion To A Grid-Based Mdp

Assume that we would like to find the approximation of the value function using our gridbased convex rule and grid-based update (Equation 9). We can view this process also as a process of finding a sequence of values ϕ 1 ( bf ), ϕ 2 ( bf ), ۰۰۰ , ϕ i ( bf ), ۰۰۰ for all grid-points bf ∈ G. We show that in some instances the sequence of values can be computed without applying an interpolation-extrapolation rule in every step. In such cases, the problem can