viding the semantics of web/XML documents), DLs are prime contenders because of their clear semantics and well-studied computational properties.

In Description Logics, one takes an object-centered view, where the world is modeled as individuals, connected by binary relationships (here called roles ), and grouped into classes
(called concepts). For those more familiar with Predicate Logic, objects correspond to constants, roles to binary predicates, and concepts to unary predicates. In every DL system, the concepts of the application domain are described by concept descriptions that are built from atomic concepts and roles using the "constructors" provided by the DL language. For example, consider a situation where we want a concept describing individual cars that have had frequent (at least 10) repairs, and also record the fact that for cars, their model is the same as their manufacturer's model. Concepts can be thought of as being built up from (possibly nested) simpler noun-phrases, so the above concept, called Lemon in the sequel, might be captured as the conjunction of
(objects that are Cars) (things all of whose model values are in concept Model)
(things all of whose madeBy values are in concept Manufacturer) (things whose model value is the same as the model of the madeBy attribute) (things with at least 10 repairs values) (things all of whose repairs values are RepairReport).

Using the syntax of the CLASSIC language, we can abbreviate the above, while emphasizing the term-like nature of descriptions and the constructors used in each:

## (And Car

(all model Model)
(all madeBy Manufacturer)
(same-as (model) (madeBy o model)) (at-least 10 repairs)
(all repairs RepairReport))
So, for example, the concept term ( at-least n p ) has constructor at-least, and denotes objects which are related by the relationship p to at least n other objects; in turn, (all p C) has as instances exactly those objects which are related by p only to instances of C.

Finally, we present the same concept in a mathematical notation which is more succinct and preferred in formal work on DLs:
Lemon :=   Car Π
∀model.Model Π
VmadeBy.Manufacturer Π
madeBy ↓ (model o madeBy) Π
≥ 10 repairs Π
 Vrepairs.RepairReport Unlike preceding formalisms, such as semantic networks and frames (Quillian, 1968; Minsky, 1975), DLs are equipped with a formal semantics, which can be given by a translation into