
## 1.2 Total Vs. Partial Attributes

In most knowledge representation systems, including DLs, functional relationships, here called attributes (also called "features" in the literature), are distinguished as a subclass of general relationships, at least in part because functional restrictions occur so frequently in practice 2 . In the above example, clearly madeBy and model are meant to be attributes, thus making unnecessary number restrictions like (and (at-most 1 madeBy) (at-least 1 madeBy)). In addition, distinguishing attributes helps identify tractable subsets of DL
constructors: in CLASSIC, coreferences between attribute chains (as in the above examples)
can be reasoned with efficiently (Borgida & Patel-Schneider, 1994), while if we changed to roles, e.g., allowed (same-as (repairs) (ownedBy orepairsPaidFor)), the subsumption problem becomes undecidable (Schmidt-Schauß, 1989).

Whereas the distinction between roles and attributes in DLs is both theoretically and practically well understood, we have discovered that another distinction, namely the one between attributes being interpreted as total functions ( total attributes ) and those interpreted as partial functions ( partial attributes ), has "slipped through the cracks" of contemporary research. A total attribute always has a value in "the world out there", even if we do not know it in the knowledge base currently. A partial attribute may not have a value. This distinction is useful in practice, since there is a difference between a car possibly, but not ncessarily, having a CD player, and the car necessarily having a manufacturer (which just may not be known in the current knowledge base). The latter is modeled by defining the attribute madeBy to be a total attribute. Note that with madeBy being a total attribute, every individual in the world of discourse (not only cars) must have a filler for madeBy. Since, however, no structural information is provided for fillers of madeBy of non-car individuals, all implications drawn about these fillers are trivial. Thus, making madeBy a total attribute seems reasonable in this case. A car's CD player, on the other hand, should be modeled by a partial attribute to express the fact that cars are not required to have a CD
player. To indicate that a particular car does have a CD player, one would have to add the description (at-least 1 CDplayer).

## 1.3  New Results

As mentioned above, in conjunction with the same-as constructor, roles and attributes behave very differently with respect to subsumption. The main objective of this paper is to show that the distinction between total and partial attributes induces significantly different behaviour in computing the lcs, in the presence of same-as .  More precisely, the purpose of this paper is twofold.

First, we show that with respect to the complexity of deciding subsumption there is no difference between partial and total attributes. Borgida and Patel-Schneider (1994) have sssees to the control be decided in polynomial time. As shown in the present work, slight modifications of the algorithm proposed by Borgida and Patel-Schneider suffice to handle partial attributes.