# The Complexity Of Reasoning With Cardinality Restrictions And Nominals In Expressive Description Logics

## Stephan Tobies

T OBIES@INFORMATIK.RWTH-AACHEN.DE
LuFG Theoretical Computer Science, RWTH Aachen Ahornstr. 55, 52074 Aachen, Germany

## Abstract

We study the complexity of the combination of the Description Logics ALCQ and ALCQI
with a terminological formalism based on cardinality restrictions on concepts. These combinations can naturally be embedded into C 2 , the two variable fragment of predicate logic with counting quantifiers, which yields decidability in NEXPTiME. We show that this approach leads to an optimal solution for ALCQI, as ALCQI with cardinality restrictions has the same complexity as C 2 (NE XP T IME -complete). In contrast, we show that for ALCQ, the problem can be solved in E XP T IME . This result is obtained by a reduction of reasoning with cardinality restrictions to reasoning with the (in general weaker) terminological formalism of general axioms for ACQ extended with nominals . Using the same reduction, we show that, for the extension of ALCQI with nominals, reasoning with general axioms is a NE XP T IME -complete problem. Finally, we sharpen this result and show that pure concept satisfiability for ALCQI with nominals is NEXPTIME-complete. Without nominals, this problem is known to be PSPACE-complete.

## 1. Introduction

Description Logics (DLs) can be used in knowledge based systems to represent and reason about taxonomical knowledge of the application domain in a semantically well-defined manner (Woods & Schmolze, 1992). They allow the definition of complex concepts (i.e., classes, unary predicates) and roles (binary predicates) to be built from atomic ones by the application of a given set of constructors. For example, the following concept describes those parents having at least two daughters:

## Human ∩ (Male ∪ Female) ∩ (≥ 2 Haschild Female) ∩ Vhaschild.Human

This concept is an example for the DL ALCQ. ALCQ extends the "standard" DL ALC
(Schmidt-Schauß & Smolka, 1991) by qualifying number restrictions, i.e., concepts restricting the number of individuals that are related via a given role (here hasChild), instead of allowing only for existential or universal restrictions like ALC. ALCQ is a syntactic variant of the (multi-)modal logic K with graded modalities (Fine, 1972). In this paper we will study problems for the DLs ALCQ and ALCQL . The latter extends ALCQ with the possibility to refer to the inverse of role relations. Additionally, in this paper we will encounter nominals, i.e., concepts referring to single elements of the domain. The extensions of ALCQ and ALCQI
with nominals are denoted by ALCQO and ALCQIO . An example concept of ALCQIO that describes the common children of the individuals ALICE and BOB living with ALICE or BOB
is

## ⇒Haschild- 1 .Alice ∩ ⇒Haschild- 1 .Bob ∩ ⇒Liveswith.( Alice └ Bob ).
