# Backbone Fragility And The Local Search Cost Peak

Josh Singer Division of Informatics, University of Edinburgh 80 South Bridge, Edinburgh EH1 1HN, United Kingdom Ian P.  Gent School of Computer Science, University of St. Andrews North Haugh, St. Andrews, Fife KY16 9SS, United Kingdom Alan Smaill Division of Informatics, University of Edinburgh 80 South Bridge, Edinburgh EH1 1HN, United Kingdom JOSH UAS@DAI. ED. AC. UK IPG@DCS. ST-AND. AC. UK
A. SMAILL@ED.AC.UK

## Abstract

The local search algorithm WSAT is one of the most successful algorithms for solving the satisfiability (SAT) problem. It is notably effective at solving hard Random 3-SAT
instances near the so-called 'satisfiability threshold', but still shows a peak in search cost near the threshold and large variations in cost over different instances. We make a number of significant contributions to the analysis of W S AT on high-cost random instances, using the recently-introduced concept of the backbone of a SAT instance.  The backbone is the set of literals which are entailed by an instance. We find that the number of solutions predicts the cost well for small-backbone instances but is much less relevant for the large-backbone instances which appear near the threshold and dominate in the overconstrained region. We show a very strong correlation between search cost and the Hamming distance to the nearest solution early in W SAT 's search.  This pattern leads us to introduce a measure of the backbone fragility of an instance, which indicates how persistent the backbone is as clauses are removed. We propose that high cost random instances for local search are those with very large backbones which are also backbone-fragile. We suggest that the decay in cost beyond the satisfiability threshold is due to increasing backbone robustness (the opposite of backbone fragility).  Our hypothesis makes three correct predictions.  First, that the backbone robustness of an instance is negatively correlated with the local search cost when other factors are controlled for.  Second, that backbone-minimal instances (which are 3-SAT
instances altered so as to be more backbone-fragile) are unusually hard for W S AT . Third, that the clauses most often unsatisfied during search are those whose deletion has the most effect on the backbone. In understanding the pathologies of local search methods, we hope to contribute to the development of new and better techniques.

## 1. Introduction
