is there a reasonable ordering between the two atomic goals? Intuitively, the blocks world domain possesses a very natural goal ordering, namely that the planner should start building each tower from the bottom to the top and not the other way round. 2 Let us first investigate whether the relation on ( a, b ) ≤ e on ( b, c ) holds. Vividly speaking, it asks whether it is still possible to stack the block a on bafter on ( b, c ) has been achieved.

As a first step, we run GRAPHPLAN to find out which atoms are exclusive of on ( b, c ) when the planning graph, which corresponds to this problem, has leveled off. The result is Fon(b,c) = {clear(c), on-table(b), holding(c), holding(b), on(a,c), on(c,b), on(b,a)}
One observes immediately that these atoms can never be true in a state that satisfies on (b,c).

Secondly, we remove all ground actions which delete on(b, c) (in this case, only the action unstack(b,c) satisfies this condition) and obtain the reduced action set O on (b,c).

Now we are ready to test if on ( a, b ) ≤ e on ( b, c ) holds. The only action, whi can add on(a, b) is stack(a,b). It has the preconditions holding(a) and clear(b), neither of which is a member of Fon(b,c) . The test fails and we get on(a, b) Le on(b,c).

As a next step, we test whether on ( b, c ) ≤ e on ( a, b ) holds. GRAPHPLAN returns the following False set:

$$c\,\big),\ \ \sigma$$
$$u(c,b\,),\,\,o n(b,a\,)\}$$
$\frac{1}{2}$  4. 

## = {Clear(B), On-Table(A), Holding(B), Holding(A), On(A,C), On(C,B), On(B,A)}

The action unstack(a,b) is not contained in O on(a,b) because it deletes on(a,b) . The only action which adds on ( b,c ) is stack(b,c).  It needs the preconditions clear(c ) and holding(b).  The second precondition holding(b) is contained in the set of false facts, i.e., holding( b ) ∈ Fon (α, b ) and thus, we conclude on ( b, c ) ≤ e on (α, b ). Altogether, we have on(a, b) Le on(b, c) and on(b, c) ≤ e on(a, b), which correctly reflects the intuition that b needs to be stacked onto c before a can be stacked onto b.

Although ≤ e appears to impose very strict conditions on a domain in order to derive a reasonable goal ordering, it succeeds in finding reasonable goal orderings in all available test domains in which such orderings exists.  For example, in the tyreworld, in bulldozer problems, in the shopping problem (Russel & Norvig, 1995), the fridgeworld, the glass domain, the tower of hanoi domain, the link-world, and the woodshop. Its only disadvantage are the computational resources it requires, since building planning graphs, while being theoretically polynomial, is a quite time- and memory-consuming thing to do. 3 Therefore, the next section presents a fast heuristic computation of goal orderings, which analyzes the domain actions directly and does not need to build planning graphs anymore.