
## 3.2 Reasonable Goal Orderings Derived By A Fast Heuristic Method

One can analyze the available actions directly using a method we will call Direct Analysis
(DA). It determines an initial value for F by computing the intersection of all delete lists of all actions which contain A in their add list, as defined in the following equation.

$$\mathsf{F}_{D A}^{A}:=\bigcap_{o\,\in\,\mathcal{O},\,A\,\in\,a\,d d(o\,)}d e l(o)$$
$$\left({3}\right)$$

The atoms in this set are all FALSE in a state where A has just been achieved: they are deleted from the state description independently of the action that is used to add A. As a short example, let us consider the two actions

$$\begin{array}{r l}{\longrightarrow}&{{}\mathrm{ADD}\setminus\{A\}}\end{array}\ \ \mathrm{DEL}\setminus\{C,D\}$$
$$\longrightarrow\ \mathrm{ADD}\ \ \{A,C\}\ \ \mathrm{DEL}\ \ \{D\}$$

Only the atom D is deleted by both actions, and thus D is the only element initially contained in FA
However, Equation (3) only says that when A is added then the atoms from F A will be deleted. It does not say anything about whether it might be possible to reestablish atoms in FAA.  One can easily imagine that actions exist, which leave A true, and at the same time add such atoms. If this is the case, there are reachable states in which A and atoms from F A  hold.

Now, our goal is to derive an ordering relation that can be easily computed, and that ideally, like the < e relation, is sufficient for the < r relation. Therefore, we want to make sure that the atoms in FAA are really FALSE in any state after A has been achieved. We arrive at an approximation of atoms that remain FALSE by performing a fixpoint reduction on the FA set, removing those atoms that are achievable in the following sense. Definition 11 (Achievable Atoms) An atom p is aievable from a state s given an action set O (written A(s, p, O)) if and only if

$$\mathbf{v}\;P\;\subset P^{\prime}\;c(\mathbf{c})$$

p E s V H o E O : p E add(o) ^ V p' E pre(o) : A(s,p',O)
The definition says that an atom p is achievable from a state s if it holds in s, or if there exists an action in the domain, which adds p and whose preconditions are all aievable from s. This is a necessary condition for the existence of a plan P O from s to a state where p holds.

Lemma 2 ∃ P O : p ∈ Result(s, P O ) ⇒ A(s, p, O)
Proof: The atom p must either already be contained in the state s, or it has to be added by a step o out of P O . In the second case, all preconditions of o need to be established by P o in the same way.  Thus p and all preconditions of the step, which adds it, are achievable in the sense of Definition 11