There are two obvious difficulties with Definition 11: First, p E s must be tested. With complete knowledge about the state s, this should not cause any problems. In our case, however, we only have the generic state s(A,-B) and cannot decide whether an arbitrary atom is contained in it or not.  Secondly, we observe an infinite regression over preconditions, which must be tested for achievability.

As for the first problem, it turns out that it is a good heuristic to simply assume p & s, i.e., no test is performed at all. As for the second problem, in order to avoid infinite looping of the "achievable"-test, one needs to terminate the regression over preconditions at a particular level. The point in question is how far to regress? A quick approximation simply decides "achievable" after the first recursive call.

Definition 12 (Possibly Achievable Atoms) An atom p is possibly achievable given an action set O (written pA(p, O)) if and only if
∃ o ∈ O : p ∈ add(o) ∧ ∀ p ′ ∈ pre(o) : ∃ o ′ ∈ O : p ′ ∈ add(o ′ )
holds, i.e., there is an action that adds p and all of its preconditions are add effects of other actions in O.

If the assumption is justified that none of the atoms p is contained in the state s, then being possibly achievable is a necessary condition for being achievable.

Lemma 3  Let s be a state for which p & s and also Vo E O : p E add(o) ⇒ pre(o) N s = 0 holds. Then we have

$${\mathcal{A}}(\,s,p\,,\,{\mathcal{O}})\Rightarrow p{\mathcal{A}}(p,\,{\mathcal{O}})$$

Proof: From A ( s,p,O ) and p & s, we know that there is a step o E O, p E add ( o ), with
∀ p' E pre(o) A(s, p', O). We also know that pre(o) ∩ s = ∅, so for each p' ∈ pre(o) there must be an achiever o' E O : p' E add(o').

The condition that all of the facts p must not be contained in the state s seems to be rather rigid. Nevertheless, the condition of being possibly achievable delivers good results on all of the benchmark domains and it is easy to decide. We can now use this test to both
- perform a fixpoint reduction on the set FAA and
- decide whether an atomic goal B should be ordered before A .

The fixpoint reduction, as depicted in Figure 1 below, uses the approximative test pA(f, O*) to remove facts from FAA that can be achieved.  It finds all these facts under certain restrictions, see below. As a side effect of the fixpoint algorithm, we obtain the set O* of actions that our method assumes to be applicable after a state s(A,-B). We then order B
before A iff it cannot possibly be achieved using these actions.