F* := FA
0* := OA \ {o | F* Npre(o) ≠ 0 }
fixpoint_reached := FALSE
while ¬ fixpoint_reached

fixpoint_reached := TRUE for f E F* if pA(f, O*) then F* := F* \ { f } 0* := OA \ {o | F* ∩ pre(o) ≠ ∅} fixpoint_reached := FALSE end if endfor

![0_image_0.png](0_image_0.png)

The computation checks whether atoms of F*, which is initially set to FA, are possibly achievable using only those actions, which do not delete A and which do not require atoms from F* as a precondition. Achievable atoms are removed from F*, and O* gets updated accordingly. If in one iteration, F* does not ange, the fixpoint is reaed, i.e., F* will not further decrease and O* will not further increase—the final sets F* of false facts and O* of applicable actions are returned.

Let us illustrate the fixpoint computation with a short example consisting of the empty initial state, the goals {A, B}, and the following set of actions op1 :

$$\begin{array}{c}{{\mathbf{r}}}\\ {{\mathbf{o p2}\!:}}\\ {{\mathbf{o p3}\!:}}\\ {{\mathbf{o p4}\!:}}\end{array}$$
AD { A } DEL { C, D } AD {A, C } DEL { D } { C } AD { D } -- { D }
When assuming that A has been achieved, we obtain F* = FA = {D} as the initial value of the False set, since D is the only atom that op1 and op2 delete when adding A .

Figure 2 illustrates a hypothetical planning process. Starting in the empty initial state and trying to achieve A first, we get two different states s(A,-B) in which A holds. The atom D does not hold in any of them and thus in both states, no action is applicable that requires D as a precondition. This excludes op4 from OA, yielding the initial action set 0* = {op1,op2,op3}. Now, op4 is the only action that can add B . Therefore, if we used this action set to see if B can still be achieved, we would find that this is not the case. Consequently, without performing the fixpoint computation, we would order B before A .

But as can be seen in Figure 2, this would not be a reasonable ordering: there is the plan
(op3 ,op4) that achieves B from the state s(A,-B) = Result(I,op2) without destroying A.

The fixpoint computation works us around this problem as follows: There is the action op3, which can add the precondition D of op4 without deleting A. When checking pA(D, O*) in the first iteration, the fixpoint procedure finds this action. It then checks