Proof: Recalling Definition 9 and assuming non-triviality of < f , we know that there is at least one state s(A,-B) where A is made TRUE, but B is still FALSE. From Definition 7, we know that there is no plan in any such state that achieves B . In particular, it is not possible to achieve all goals starting out from s(A,-B). Thus, the state s := s(A,-B) must be a deadlock.

We will now investigate deadlocks in more detail and discuss that most of the commonly used benchmark problems do not contain them, i.e., they are deadlock-free. With Lemma 5, we then also know that such domains do not contain non-trivial forced goal orderings either—so there is not much point in trying to find them. We do not care about trivial goal orderings. Such orderings force any reasonable planning algorithm to consider the goals in the correct order.

The existence of deadlocks depends on structural properties of a planning problem:
There must be action sequences, which, once executed, lead into states from which the goals cannot be reached anymore. These sequences must have undesired effects, which cannot be inverted by any other sequence of actions in O . Changing perspective, one obtains a hint on how a sufficient condition for the non-existence of deadlocks might be defined. Assume we have a planning problem where the effects of each action sequence in the domain can be inverted by executing a certain other sequence of actions. In such an invertible planning problem, it is in particular possible to get back to the initial state from each reachable state. Therefore, if such a problem is solvable, then it does not contain deadlocks: From any state, one can reach all goals by going back to the initial state first, and then execute an arbitrary solution thereafter. We will now formally define the notion of invertible planning problems, and turn the above argumentation into a proof.

Definition 15 (Invertible Planning Problem) Let (O, I, G) be a planning problem, and let s denote the states that are reachable from I with actions from O. The problem is called invertible if and only if

$$\forall\,{\mathcal{P}}^{\mathcal{O}}:\ \exists\,{\mathcal{P}}^{\mathcal{O}}:\,R e s u l t$$
$$e s u l t(s,{\mathcal{P}}^{\smile}),{\mathcal{P}}^{\smile})=$$

∀ s : ∀ P ◦ : ∃ P ◦ : Result(Result(s,P ◦ ), P ◦ ) = s Theorem 6 Let (O, I, G) be an invertible planning problem, for which a solution exists.

Then (O, I, G) does not contain any deadlocks.

Proof: Let s = Result( I, P g ) be an arbitrary reachable state. As the problem is invertible, we know that there is a sequence of actions P s for which Result(s, P s ) = I holds.

As the problem is solvable, we have a solution plan Po starting from I and achieving G ⊆ Result(I, P ⁰ ). Together, we obtain G ⊆ Result(Result(s, P ∗ ), P ⁰ ). Therefore, the concatenation of P o and P o is a solution plan executable in s and consequently, s is no deadlock.

n We now know that invertible planning problems, if solvable, do not contain deadlocks and consequently, they do not contain (non-trivial) forced goal orderings. What we will see next is that, as a matter of fact, most benchmark planning problems are invertible. We arrive at a sufficient condition for invertibility through the notion of inverse actions.