- Goals A, B that lie on a cycle in G belong to the same set, i.e., A, B E Gi.

- If G contains a path from a goal A to a goal B, but not vice versa, then A is ordered before B , i.e., A ∈ G i and B ∈ G i with i < j.
These are the only properties that appear to be reasonable for a goal-set sequence respecting the atomic orderings. We will now introduce a simple algorithmic method that does produce a sequence of goal sets which meets these requirements.

First of all, the transitive closure of G is computed. This can be done in at most cubic time in the size of the goal set (Warshall, 1962). Then, for each node A in the transitive closure, the ingoing edges A in and outgoing edges A out are counted. All disconnected nodes with A in = A qut = 0 are moved into a separate set of goals G-sep containing now those atomic goals, whi do not participate in a ≤ relation. For all other nodes A, their degree d(A) = A in − A out is determined as the difference between the number of ingoing edges and the number of outgoing edges. Nodes with identical degree are merged into one set. The sets are then ordered by increasing degree and yield our desired sequence of goal sets. The only problem remaining is the set G-sep. If it is non-empty, it is not clear in which place to put it.

Let us consider a small example of the process. Figure 3 depicts on the left the goal

![0_image_0.png](0_image_0.png)

graph, which results from the goal set G = {A, B, C, D, E} and the ordering relations A < B, B < C and B < D, and its transitive closure on the right.

In Figure 4, the number of in- and outgoing edges of each goal, the corresponding degrees, and resulting goal-set sequence are shown.

![0_image_1.png](0_image_1.png)

Figure 4: On the left, the number of in- and outgoing edges for each node. On the right, the degree of the nodes and the merged sets of goals having same degree.  The node E becomes a member of the G-sep set and remains unordered.
It is not difficult to verify that the resulting goal sequence respects the atomic goal orderings: