- Nodes occurring on a cycle in a graph have isomorphic in- and outgoing edges in the transitive closure of that graph. In particular, they have the same degree and get merged into the same set Gi.

- Say we have a graph, where there is a path from A to B, but not vice versa. Then, in the transitive closure of that graph, we will have an edge from A to each node that B has a path to, and additionally the edge from A to B, i.e., Aout > Bout follows. Similarly, we have an ingoing edge to B for each node that has a path to A, and additionally, the edge from A to B, which gives us Bin > Ain. Altogether, d(A) = Ain = Aout < Bin = Aout < Bin = Bout = d(B) and thus, the degree of A is smaller than the degree of B and as required, A gets ordered before B .
Note that nothing is said in this argumentation about the set of unordered goals, G-
sep. This set could, in principle, be inserted anywhere in the sequence with the resulting sequence still respecting the atomic orderings. A possible heuristic may use this goal set as the first in the sequence, because apparently there is no problem to reach all other goals after the goals in this set have been achieved.  Another heuristic could put this set at the end as there is neither a problem to reach this goal set from all other goals. We have decided to deal with the problem in a more sophisticated way by trying to derive an ordering relation between G-sep and the other goal sets Gi that have already been derived. In order to do so, we need to extend our definitions of goal orderings to sets of goals.

## 4.2 Extension Of Goal Orderings To Goal Sets

Given a set of atomic goals, it has always been a problem which of the exponentially many subsets should be compared with each other in order to derive a reasonable goal ordering between goal sets. A consideration of all possible subsets is out of question, because it will result in an exponential overhead. The partial goal agenda that we have obtained so far offers one possible answer. It suggests taking the set G-sep and trying to order it with respect to the goal sets emerging from the goal graph.

Given a planning problem ( O , I , G ) and two subsets of atomic goals { A 1 , . . , A n } ⊆ G
and { B 1 , . . , B k } ⊆ G , the definition of ≤ e and ≤ h for sets of atomic goals is straightforward. For the sake of simplicity, we consider only STRIPS actions here. The definitions can be directly extended to ADL.

To define an ordering ≤ E , which extends ≤ e to sets, we begin by defining a set F { A 1 ,…, A n }
of all atoms, which are exclusive of at least one atomic goal A; in the planning graph generated for ( O, I, G):
F{A 1 ,…,A n} := {p | p is exclusive of at least one A i when the graph has leveled off }
The set O{A;,...,A, } is obtained accordingly by removing from O all actions that delete at least one of the Ai, i.e., O{Ai,...,An} = {o E O | Vi E {1,...,n} : Ai Q dd(o)}.

Definition 19 (Ordering ≤ E over Goal Sets) Let (O, I, G) be a planning problem with
{A 1 , . . , A n } ⊆ G and {B 1 , . . , B k } ⊆ G . Let F{A 1 , . . A n } be the False set for {A 1 , . . , A n } .

The ordering { B 1 , . . , B k } ≤ E { A 1 , . . . A n } holds if and only if
∃ j ∈ {1, . . , k} : ∀ o ∈ O{A 1 ,...,A n } : B j ∈ add(o) ⇒ pre(o) ∩ F{A 1 ,...,A n } ̸ = ∅.