This result states the feasibility of our approach: As we have shown, most benchmark problems that are currently investigated do contain inverse actions, are therefore invertible (Theorem 7), and are with that also deadlock-free (Theorem 6). Thus, with Theorem 8, our approach preserves completeness in these domains.

However in the general case, completeness cannot be guaranteed.  The following example illustrates a situation where the assumption s(A,-B) F p (assuming that preconditions of achieving actions are not contained in the state where A is reached, cf. the derivation of the ordering <h in Section 3) is wrong and yields a goal ordering under which no plan can be found anymore although the problem is solvable.

Given the initial state { C, D} and the goals { A, B}, the planner has the following set of ground STRIPS actions :
op1: {C} −→ ADD {B} DEL {D}
op2: {D} --> ADD {E}
op3: {E} —} ADD {F} op4: {F} --> ADD {A}
The analysis will return an ordering B ≤ h A because B is only added by op1, but its precondition C is not an effect of any of the other actions. Thus it concludes that C is not reachable from a state in which A holds. But in this example, C holds in all reachable states.  The assumption s ( A , B ) can be reached after A. On the other hand, A <r B holds, we even have a forced ordering A < f B .  But when testing for A < h B , this ordering remains undetected, because our method does not discover that the precondition F of op4 is not aievable from the state in which B holds: we obtain F B A = { D }, which excludes op2 from O*, but op3 and op4 remain in the set of usable actions. Thus, op4 is considered a legal achiever of A, and op3 is considered a legal achiever for its precondition F .  We could only detect the right ordering if we regressed over the action chain op4 , op3 , op2 and found out that, with D being in the F set of B t all these actions must be excluded from O*.

Consequently, the goal agenda { B }, { A } is fed into the planner, which solves the first subproblem using op1 , but then fails in achieving A from the state { B, C } since there is no inverse action to op1 and D cannot be re-established in any other way.

## 5.  Empirical Results

We implemented both methods to approximate ≤ r as a so-called Goal Agenda Manager
(GAM) for the IPP planning system (Koehler et al., 1997).  GAM is activated after the set of ground actions has been determined and either uses <e or <h to approximate the reasonable goal ordering. Then it calls the IPP planning algorithm on each entry from the goal agenda and outputs the solution plan as the concatenation of the solution plans that have been found for each entry in the agenda. 7