The empirical evaluation that we performed uses the IPP domain collection, which contains 48 domains with more than 500 planning problems. Out of these domains, we were able to derive goal ordering information in 10 domains. These domains indeed pose constraints on the ordering in which a planner has to a achieve a set of goals. In all other domains, where no goal orderings could be derived, we found that either only a single goal has to be achieved, for example in the manhattan, movie, molgen, and montlake domains or the goals can be achieved in any order, as for example in the logistics, gripper, and ferry domains. We found no benchmark domain, in whi a natural goal ordering existed, but our method failed to detect it. As a matter of fact, looking at a goal ordering that seems to be natural, one usually finds that the ordering is reasonable in the sense of Definition 8, see for example the blocks world, woodshop, and tyreworld domains. Our method finds almost all of the reasonable orderings, which indicates that both approximation techniques < e and
< h are appropriate for detecting ordering information.

In the following, we will first compare the <e and <h techniques in terms of runtime and number of goal agenda entries generated. Then we take a closer look at the agendas that are generated in selected domains and investigate how they influence the performance of the IPP planning system. The exact definition of all domains can be downloaded from the IPP webpage, we just give the name of the domain and the name of the particular planning problem as well as the number of (ground) actions a domain contains, because this parameter nicely characterizes the size of a domain and with that usually the difficulty to handle it.

In all examples, the times shown to compute the goal agenda contain the effort to parse and instantiate the operators, i.e., to compute the set of actions. Times for parsing and instantiation are not listed explicitly, because they are, on the test examples used here, usually very close to zero and do not influence the performance of the planner in a significant way.

## 5.1  Comparison Of ≤ H And ≤ E

We begin our comparison with a summary of results that we obtained in different representational variants of the blocks world. The bw_large_a to bw_large_d examples originate from the SATPLAN test suite (Kautz & Selman, 1996) to which we added the larger examples bw_large_e to bw_large_g. The parcplan example comes from (El-Kholy & Richards, 1996)
and uses multiple grippers and limited space on the table. The stack n examples use the GRAPHPLAN blocks world representation and simply require to stack n blocks on each other, which are all on the table in the initial state.

The two methods return exactly the same ordering relations across all blocks world problems. But as Figure 5 confirms, the computation of <e based on planning graphs is much more time-consuming.  It hits the computational border when a domain contains more than 10000 actions. The computation of <h is much faster and also scales to larger action sets.