The optimal plan of 20 actions solving the problem is found by IPP using GAM in 14 s, where it spends one second on computing the goal agenda, almost 13 seconds to build the planning graphs, but only 0.01 second to search for a plan. Only 70 actions have to be tried to find the solution. Without the goal analysis, IPP needs approx. 47 s and searches 52893 actions in more than 26 seconds.

RIFO (Nebel et al., 1997) fails in detecting a subset of relevant actions when the original goal set has to be considered, but it succeeds in selecting relevant actions for the subproblems stated in the agenda. It reduces runtime down to less than 8 s with 1 s again spent on the goal agenda, almost 6 s spent on the removal of irrelevant actions and initial facts, less than 1 s spent on building the planning graphs. As previously, almost no time is spent on planning.

Figure 9 shows IPP on the SATPLAN blocks world examples from (Kautz & Selman, 1996), the bw Jarge.e example taken from (Dimopoulos, Nebel, & Koehler, 1997), and two very large examples bw large f (containing 25 blocks and requiring to build 6 stacks in the goal state) and bw large.g with 30 blocks/8 stacks.

| SATPLAN   | # actions   | plan length   | IPP   | +G    | +G+R   | +G+R+L   |
|-----------|-------------|---------------|-------|-------|--------|----------|
| bwlarge.a | 162         | 12 (12)       | 0.70  | 0.74  | 0.58   | 0.34     |
| bwlarge.b | 242         | 2 (18)        | 26.71 | 0.86  | 0.55   | 0.52     |
| bwlarge.c | 450         | 7.34          | 2.42  | 2.58  |        |          |
| 48        |             |               |       |       |        |          |
| bwlarge.d | 722         | 54            | 1.62  | 3.74  | 3.81   |          |
| bwlarge.e | 722         | 52            | 11.14 | 3.99  | 3.97   |          |
| bwww      | 1250        | 90            | 16.01 |       |        |          |
| bwlarge.g | 1800        | 84            | 17.56 | 28.71 |        |          |
| -         |             |               |       |       |        |          |

Figure 9: Performance on the extended SATPLAN blocks world test suite.  The second column shows the number of ground actions in this domain, the third column shows the plan length, i.e., the number of actions contained in the plan, generated by  GAM and in parentheses the plan length generated by IPP without GAM given that IPP without GAM is able to solve the corresponding problem. +G means that IPP is using GAM, +G+R means IPP uses GAM and RIFO, +G+R+L means that subgoals from the same set in the agenda are arbitrarily linearized.

All runtimes cover the whole planning process starting with parsing the operator and domain file, performing the GAM and RIFO analysis (if active), and then searching the graph until a plan is found.

IPP 3.3 without GAM can only solve the bw_large.a and bw_large.b problems. Using a goal agenda, some plans become slightly longer, but performance is increasing dramatically.

Plan length is growing because blocks are accidentally put in positions where they cut off goals that are still ahead in the agenda and thus, additional actions need to be added to the plan to remove these blocks from wrong positions. A further speed-up is possible when RIFO is additionally used, because it reduces the size of planning graphs dramatically.

Finally, goals that belong to the same subset in the agenda can be linearized based on the