IPP is only able to solve the problem for 1 and 2 tires.  Using GAM and RIFO, 3 tires can be handled. Solution length under GAM is slightly increasing, which is caused by superfluous jack-up and jack-down actions. In short, this is explained as follows. Each wheel needs to be mounted on its hub, which is expressed by an on(?r, ?h) goal. To mount a wheel, its hub must be jacked up. After mounting, the nuts are done up. Then, the hub nnons to be jacked down again, in order to tighten the nuts achieving a tight(?n, ?h) goal. Now, GAM puts all of the on goals into one entry preceeding the tight goals. Thus, solving the entry containing the on goals, each hub is jacked up, the wheel is put on, and the hub is immediatly jacked down again in order to replace the next wheel. Afterwards, solving the tight goals, each hub must be jacked up—and down—one more time for doing up the nuts. Solving the problem in this manner, the planner inserts one superfluous jack up , and one superfluous jack-down action for each wheel.  More precisely, superfluous actions are inserted for all but one wheel, namely the wheel that is last mounted when solving the on goals. After mounting this wheel, all on goals are achieved, and the planner proceeds to the next agenda entry with this wheel still being jacked up. Then, trying to aieve the tight goals, IPP recognizes that the shortest plan (in terms of the number of parallel steps)
results when the nuts are first done up on the hub that is already jacked up. Thus, this hub is only jacked up one time, achieving the corresponding on goal, and jacked down again one time, before achieving its tight goal. In the case of 3 tires, the following goal subsets are identified and ordered:
1: inflated(r3), inflated(r2), inflated(r1)
2: on(r3, hub3), on(r1, hub1), on(r2, hub2) 3: tight(n2, hub2), tight(n3, hub3), tight(n1, hub1)
4: in(w3, boot), in(pump, boot), in(w1, boot), in(w2, boot) 5: in(jack, boot)
6: in(wrench, boot) 7: closed(boot)
The hardest subproblem in the agenda is to achieve the on ( r i , hub i ) goals in entry 2, i.e., to mount inflated spare wheels on the various hubs. Trying to generate a maximum parallelized plan is impossible for IPP for more than 3 tires. But since the goals are completely independent of each other, any linearization of them will perfectly work. The resulting plans become slightly longer due to the way that the tight goals are achieved when using the -L option. We noticed earlier that for one wheel (the one that is last mounted when solving the on goals) no superfluous jack-up and jack-down actions need to be inserted into the plan. Linearizing the agenda entries, superfluous jack-up and jack-down actions must most likely be inserted for all wheels, yielding plans that are two steps longer. The reason for that is that any tight goal might be the first in the linearization. Most likely, this is not the tight goal corresponding to the hub that is still jacked up, so the planner needs to insert one superfluous jack down action here. Later, it must jack up this hub again, yielding another superfluous action. Using +G+R+L in the case of 10 tires, only 2662 actions need to be tried until a plan of 136 actions is found, which takes 0.08 s.  GAM requires 0.55 s, RIFO requires 14.42 s, 1.74 s are consumed to generate the planning graphs, and 0.08 s are spent to compute the initial states for all subproblems. The remaining 0.02 s are consumed for parsing and instantiating.