solution for a goal B anyway, then the goal A can be removed from the goal set without changing the planning task.

The authors report that they are able to detect necessary orderings in the artificial domains DiSi, cf. (Barrett & Weld, 1994), but fail in typical benchmark domains such as the blocks world or the tyreworld. The reason for this seems to be that their operator graphs do not represent all possible instantiations of operator schemes. As the authors claim, this makes operator graph analysis very efficient. However, the heuristic ordering < h that we introduced in this paper also takes almost no computation time, and succeeds in finding the goal orderings in these domains.

## 7. Outlook

Three promising avenues for future research are the following:
First, one can imagine that goal ordering information is also used during the search process, i.e., by not only ordering the original goal set, but also other goals that emerge during search.  The major challenge seems to balance the effort on computing the goal ordering information with the savings that can result for the search process.  One can easily imagine that ordering all goal sets that are ever generated can become a quite costly investment without yielding a major benefit for the planner.

Secondly, the refinement of the goal agenda with additional subgoals is another interesting future line of work. A first investigation using so-called intermediate goals (these are facts that the planner must make TRUE before it can achieve an original goal) has been explored inside GAM and the results are reported in (Koehler & Hoffmann, 1998). Earlier work addressing the task of learning intermediate goals can be found in (Ruby & Kibler, 1989), but this problem has not been in the focus of AI planning research since then.

A third line of work addresses the interaction of GAM with a forward-searching planning system.  We have seen that GAM preserves the correctness of a planner, and that it preserves the completeness at least on deadlock-free planning domains.  We have also seen, however, that solution plans using GAM can get longer, i.e., GAM does not preserve the optimality of a planner. Recently, planning systems that do not deliver plans of guaranteed optimality have demonstrated an impressive performance in terms of runtime and plan length, e.g., HSP, whi is first mentioned in (Bonet, Loerincs, & Geffner, 1997),
GRT (Refanidis & Vlahavas, 1999), and in particular FF (Hoffmann, 2000). These systems are heuristic-search planners searching forward in the state space with non-admissible, but informative heuristics.

The FF planning system developed by one of the authors has been awarded "Group A
Distinguished Performance Planning System" and has also won the Schindler Award for the best performing planning system in the Miconic 10 Elevator domain (ADL track) at the AIPS 2000 planning competition. The integration of goal agenda techniques into the planner is one of the factors that enabled the excellent behavior of FF in the competition: they were crucial for scaling to blocks world problems of 50 blocks, helped by about a factor 2 on schedule and Miconic 10, and never slowed down the algorithm.

Forward state-space search is a quite natural framework to be driven by the goal agenda:
Simply let the planner solve a subproblem, and start the next search from the state where the last search ended. Even more appealing, heuristic forward-search planners have a deeper