
## 3. The Computation Of Goal Orderings

In this section, we will

1. define a goal ordering information about facts. We prove that this ordering is sufficient for <, and that it can be decided in polynomial time (the subscript "e" stands for "efficient").

2. define a goal ordering :: which is computed based on a heuristic method that is much faster than the computation based on GRAPHPLAN , and also delivers powerful goal ordering information (the subscript "h" stands for "heuristic" ).

3. discuss that most of the currently available benchmark planning domains do not contain forced orderings, i.e., < t will fail in providing a problem decomposition for them.

4. show how our orderings can be extended to handle more expressive ADL operators.

## 3.1  Reasonable Goal Orderings Based On Graphplan

A goal ordering is always computed for a specific planning problem involving an initial state I t a goal set G D {A,B}, and the set O of all ground actions. In order to develop an efficient computational method, we proceed in two steps now:
1. We compute more knowledge about the generic state s(A,-B).

2. We define the relation < e and investigate its theoretical properties. In particular, we prove that ≤ e implies ≤ r .
The state s(A,-B) represents states that are reachable from I, and in which A has been achieved, but B does not hold. Given this information about s(A,-B), one can derive additional knowledge about it. In particular, it is possible to determine a subset of atoms F,
of which one definitely knows that F ∩ s ( A ,¬ B ) = ∅ must hold.  One method to determine F is obtained via the computation of invariants, i.e., logical formulae that hold in all reachable states, cf. (Fox & Long, 1998). After having determined the invariants, one assumes that A
holds, but B does not, and then computes the logical implications. Another possibility is to simply use GRAPHPLAN (Blum & Furst, 1997). Starting from I with O the planning graph is built until the graph has leveled off at some time step. The proposition level at this time step represents a set of states, which is a superset of all states that are reachable from I
when applying actions from O. All atoms, which are marked as mutually exclusive (Blum
& Furst, 1997) of A in this level can never hold in a state satisfying A. Thus, they cannot hold in s(A,-B). We denote this set with FAP —the False set with respect to A returned by GRAPHPLAN.

F P := {p | p is exclusive of A when the graph has leveled off}
(1)
Note that the planning graph is only grown once for a given I and O, but can be used to determine the FAP sets for all atomic goals A E G.