
$$(6)$$

We define the goal of a bias learner to be to find a hypothesis space H 2 H minimizing the following loss:

$$\mathrm{er}_{Q}(\mathcal{H}):=\int_{\mathcal{P}}\inf_{h\in\mathcal{H}}\mathrm{er}_{P}\left(h\right)dQ(P)$$ $$=\int_{\mathcal{P}}\inf_{h\in\mathcal{H}}\int_{X\times Y}l(h(x),y)\,dP(x,y)\,dQ(P).$$

The only way erQ(H) can be small is if, with high Q-probability, H contains a good solution h to any problem P drawn at random according to Q. In this sense erQ(H) measures how appropriate the bias embodied by H is for the environment (P; Q).

In general the learner will not know Q, so it will not be able to find an H minimizing erQ(H)
directly. However, the learner can sample from the environment in the following way:
 Sample n times from P according to Q to yield:

P1; : : : ; Pn.

 Sample m times from X - Y according to each Pi to yield:
zi = f(xi1; yi1) : : : ; (xim; yim)g.

 The resulting n training sets—henceforth called an (n; m)*-sample* if they are generated by the above process—are supplied to the learner. In the sequel, an (n; m)-sample will be denoted by z and written as a matrix:

$$\begin{array}{r c l}{{\left(x_{11},y_{11}\right)}}&{{\cdot\cdot\cdot}}&{{\left(x_{1m},y_{1m}\right)}}&{{=z_{1}}}\\ {{}}&{{\vdots}}&{{\ddots}}&{{\vdots}}\\ {{\left(x_{n\,1},y_{n\,1}\right)}}&{{\cdot\cdot\cdot}}&{{\left(x_{n\,m},y_{n\,m}\right)}}&{{=z_{n}}}\end{array}$$

$$\mathbf{z}:=$$

$$(7)$$
$$(8)$$

An (n; m)-sample is simply n training sets z1; : : : ; zn sampled from n different learning tasks P1; : : : ; Pn, where each task is selected according to the environmental probability distribution Q. The size of each training set is kept the same primarily to facilitate the analysis.

Based on the information contained in z, the learner must choose a hypothesis space H 2 H .

One way to do this would be for the learner to find an H minimizing the *empirical loss* on z, where this is defined by:

$$\mathrm{\acute{e r}_{z}}\left({\mathcal{H}}\right):={\frac{1}{n}}\sum_{i=1}^{n}\operatorname*{inf}_{h\in{\mathcal{H}}}\mathrm{\acute{e r}_{z_{i}}}\left(h\right)$$

^erzi (h) (8)
Note that ^erz(H) is simply the average of the best possible empirical error achievable on each training set zi , using a function from H. It is a biased estimate of erQ(H). An unbiased estimate of erQ(H) would require choosing an H with minimal average error over the n distributions P1; : : : ; Pn, where this is defined by 1 n Pn i=1 infh2H erPi (h).

As with ordinary learning, it is likely there are more intelligent things to do with the training data z than minimizing (8). Denoting the set of all (n; m)-samples by (X - Y )
(n;m)
, a general "bias learner" is a map A that takes (n; m)-samples as input and produces hypothesis spaces H 2 H as output:

$$\mathcal{A}\colon\bigcup_{\stackrel{n>0}{m>0}}(X\times Y)^{(n,m)}\to\mathbb{H}.$$

(n;m) ! H : (9)

$$(9)$$
