In general a set of "strong features" may be viewed as a function f : X ! V mapping the input space X into some (typically lower) dimensional space V . Let F = ff g be a set of such feature maps (each f may be viewed as a set of features (f1; : : : ; fk) if V = Rk). It is the f that must be
"carefully chosen" in the above quote. In general, the "simple functions of the features" may be represented as a class of functions G mapping V to Y . If for each f 2 F we define the hypothesis space G Æ f := fg Æ f : g 2 Gg, then we have the hypothesis space family H

$$\mathbb{H}:=\{{\mathcal{G}}\circ f\colon f\in{\mathcal{F}}\}.$$
H := fG Æ f : f 2 F g: (32)
Now the problem of "carefully choosing" the right features f is equivalent to the bias learning problem "find the right hypothesis space H 2 H ". Hence, provided the learner is embedded within an environment of related tasks, and the capacities C(H ; ") and C(H n l

; ") are finite, Theorem 2 tells us that the feature set f can be *learnt* rather than carefully chosen. This represents an important simplification, as choosing a set of features is often the most difficult part of any machine learning problem.

In Section 3.2 we give a theorem bounding C(H ; ") and C(H n l

; ") for general feature classes.

The theorem is specialized to neural network classes in Section 3.3.

Note that we have forced the function class G to be the same for all feature maps f , although this is not necessary. Indeed variants of the results to follow can be obtained if G is allowed to vary with f .

## 3.2 Capacity Bounds For General Feature Classes

Notationally it is easier to view the feature maps f as mapping from X - Y to V - Y by (x; y) 7! (f (x); y), and also to absorb the loss function l into the definition of G by viewing each g 2 G as a map from V - Y into [0; 1℄ via (v; y) 7! l(g(v); y). Previously this latter function would have been denoted gl but in what follows we will drop the subscript l where this does not cause confusion. The class to which gl belongs will still be denoted by Gl .

With the above definitions let Gl Æ F := fg Æ f : g 2 Gl ; f 2 F g. Define the capacity of Gl in the usual way, C ("; Gl ) := sup P

N ("; Gl ; dP )

```
where the supremum is over all probability measures on V - Y , and dP (g; g0) := R
                                                                                V Y
                                                                                    
                                                                                     jg(v; y) 
                                                                                               

```

g 0

(v; y)j dP (v; y). To define the capacity of F we first define a pseudo-metric d[P;Gl ℄ on F by
"pulling back" the L1 metric on R through Gl as follows:

$$d_{[P,\mathcal{G}_{i}]}(f,f^{\prime}):=\int_{X\times Y}\sup_{g\in\mathcal{G}_{i}}|g\circ f(x,y)-g\circ f^{\prime}(x,y)|\,dP(x,y).\tag{33}$$
$${\mathcal{C}}\left(\varepsilon,\,\mathfrak{l}\right)$$

It is easily verified that d[P;Gl℄is a pseudo-metric. Note that for d[P;Gl℄to be well defined the supremum over Gl in the integrand must be measurable. This is guaranteed if the hypothesis space family

```
H = fGl Æ f : f 2 F g is permissible (Lemma 32, part 4). Now define N ("; F; d[P;Gl ℄) to be the
smallest "-cover of the pseudo-metric space (F; d[P;Gl ℄) and the "-capacity of F (with respect to Gl )
as
                         CGl ("; F) := sup
                                    P
                                     
                                       N ("; F; d[P;Gl ℄)

```

where the supremum is over all probability measures on X Y . Now we can state the main theorem of this section.