
## 3.3.3 Discussion

1. Keeping the accuracy and confidence parameters " and Æ fixed, the upper bound on the number of examples required of each task behaves like O(k + W=n). If the learner is simply learning n fixed tasks (rather than learning to learn), then the same upper bound also applies (recall Theorem 4).

2. Note that if we do away with the feature map altogether then W = 0 and the upper bound on m becomes O(k), independent of n (apart from the less important Æ term). So in terms of the upper bound, learning n tasks becomes just as hard as learning one task. At the other extreme, if we fix the output weights then effectively k = 0 and the number of examples required of each task decreases as O(W=n). Thus a range of behavior in the number of examples required of each task is possible: from no improvement at all to an O(1=n) decrease as the number of tasks n increases (recall the discussion at the end of Section 2.6).

3. Once the feature map is learnt (which can be achieved using the techniques outlined in Baxter, 1995b; Baxter & Bartlett, 1998; Baxter, 1995a, chapter 4), only the output weights have to be estimated to learn a novel task. Again keeping the accuracy parameters fixed, this requires no more that O(k) examples. Thus, as the number of tasks learnt increases, the upper bound on the number of examples required of each task decays to the minimum possible, O(k).

4. If the "small number of strong features" assumption is correct, then k will be small. However, typically we will have very little idea of what the features are, so to be confident that the neural network is capable of implementing a good feature set it will need to be very large, implying W  k. O(k + W=n) decreases most rapidly with increasing n when W  k, so at least in terms of the upper bound on the number of examples required per task, learning small feature sets is an ideal application for bias learning. However, the upper bound on the number of tasks does not fare so well as it scales as O(W).

## 3.3.4 Comparison With Traditional Multiple-Class Classification

A special case of this multi-task framework is one in which the marginal distribution on the input space PijX is the same for each task i = 1; : : : ; n, and all that varies between tasks is the conditional distribution over the output space Y . An example would be a multi-class problem such as face recognition, in which Y = f1; : : : ; ng where n is the number of faces to be recognized and the marginal distribution on X is simply the "natural" distribution over images of those faces. In that case, if for every example xij we have—in addition to the sample yij from the ith task's conditional distribution on Y —samples from the remaining n  1 conditional distributions on Y , then we can view the n training sets containing m examples each as one large training set for the multi-class problem with mn examples altogether. The bound on m in Theorem 8 states that mn should be O(nk + W), or proportional to the total number of parameters in the network, a result we would expect from6(Haussler, 1992).

So when specialized to the traditional multiple-class, single task framework, Theorem 8 is consistent with the bounds already known. However, as we have already argued, problems such as face recognition are not really single-task, multiple-class problems. They are more appropriately viewed