Using the loss function allows us to present a unified treatment of both pattern recognition (Y =
f0; 1g, l as above), and real-valued function learning (*e.g.* regression) in which Y = R and usually

```
l(y; y0
       ) = (y  y0
                    )
                     
                     2
                      .
    The goal of the learner is to select a hypothesis h 2 H with minimum expected loss:

```

$$\operatorname{er}_{P}(h):=\int_{X\times Y}l(\,h(x),y)\,d P(x,y).$$
$$\left(2\right)$$
$$({\mathfrak{I}})$$

l(h(x); y) dP (x; y): (2)
Of course, the learner does not know P and so it cannot search through H for an h minimizing erP (h). In practice, the learner samples repeatedly from X - Y according to the distribution P to generate a *training set*

$$z:=\{\left(x_{1},y_{1}\right),\ldots,\left(x_{m},y_{m}\right)\}.$$
z := f(x1; y1); : : : ; (xm; ym)g: (3)
Based on the information contained in z the learner produces a hypothesis h 2 H. Hence, in general a learner is simply a map A from the set of all training samples to the hypothesis space H:

$${\mathcal{A}}\colon\bigcup_{m>0}(X\,\times Y)^{m}\to{\mathcal{H}}$$

(stochastic learner's can be treated by assuming a distribution-valued A.)
Many algorithms seek to minimize the *empirical* loss of h on z, where this is defined by:

$$\operatorname{er}_{z}\left(h\right):={\frac{1}{m}}\sum_{i\,=1}^{m}l\left(h\left(x_{i}\right),y_{i}\right).$$

$$\left(4\right)$$

Of course, there are more intelligent things to do with the data than simply minimizing empirical error—for example one can add regularisation terms to avoid over-fitting.

However the learner chooses its hypothesis h, if we have a *uniform* bound (over all h 2 H) on the probability of large deviation between ^erz (h) and erP (h), then we can bound the learner's generalization error erP (h) as a function of its empirical loss on the training set ^erz (h). Whether such a bound holds depends upon the "richness" of H. The conditions ensuring convergence between
^erz (h) and erP (h) are by now well understood; for Boolean function learning (Y = f0; 1g, discrete loss), convergence is controlled by the *VC-dimension*1 of H:
Theorem 1. Let P *be any probability distribution on* X - f0; 1g *and suppose* z = f(x1; y1); : : : ; (xm; ym)g is generated by sampling m *times from* X - f0; 1g according to P *. Let* d := VCdim(H). Then with probability at least 1  Æ *(over the choice of the training set* z), all h 2 H *will satisfy*

$$\operatorname{er}_{P}\left(h\right)\leq\operatorname{e}\!\mathrm{r}_{z}(h)+\left[{\frac{32}{m}}\left(d\log{\frac{2e m}{d}}+\log{\frac{4}{\delta}}\right)\right]^{1/2}$$

$$(5)$$

Proofs of this result may be found in Vapnik (1982), Blumer et al. (1989), and will not be reproduced here.