
## 3.2 Compilation Schemes

Assume a tuple of functions f hf ; fi; fg ; ti; tg i that induce a function F from X -instances h ; I; Gi to Y-instances F () as follows:

$$F^{\prime}$$
$$\langle f_{\xi}\;\;\;\;\;,\,f_{i}\;\;\;\;\;\;\;\;\;\;t_{i}\;\;\;\;,{\bf I}\;\;,\,f_{g}\;\;\;\;\;\;\;\;\;\;t_{g}\;\;\;\;,\;{\bf G}\;\;\rangle.$$

If the following three conditions are satisfied, we call f a **compilation scheme from** X to Y:
1. there exists a plan for iff there exists a plan for F ();
2. the **state-translation functions** ti and tg are **modular**, i.e., for 1 2, S  , and

$$S\ /$$

S 6j , the functions tx (for x i; g) satisfy

$${\bf u l a r,\ i.e.,\ f o r}\qquad\quad\mathrm{\boldmath~{\large~1}~}\qquad\mathrm{\boldmath~{\large~{\large~2},\ S~}}\subseteq\quad\mathrm{\boldmath~,~and}$$
$$\phi$$) stands for $$\phi$$. 
$$t_{x}\quad,\,S\quad\quad t_{x}\quad\quad1,\,S\quad\quad\widetilde{\quad\quad}\quad t_{x}\quad\quad2,\,S\quad\quad\widetilde{\quad\quad}\quad2\ ,$$

and they are polynomial-time computable; 3. and the size of the results of f ; fi, and fg is polynomial in the size of the arguments.

Condition (1) states that the function F induced by the compilation scheme f is solutionpreserving. Condition (2) states requirements on the *on-line state-translation functions*. The result of these functions should be computable *element-wise*, provided the state specification is consistent. Considering the fact that these functions depend only on the original set of symbols and the state specification, this requirement does not seem to be very restrictive. Since the state-translation functions are on-line functions, we also require that the result should be efficiently computable.7 Finally, condition (3) formalizes the idea that f is a compilation. For a *compilation* it is much more important that the result can be *concisely represented*, i.e., in polynomial space, than that the compilation process is fast. Nevertheless, we are also interested in *efficient compilation schemes*. We say that f is a **polynomial-time compilation scheme** if f ; fi , and fg are polynomial-time computable functions.

In addition to the resource requirements on the compilation process, we will distinguish between different compilation schemes according to the effects on the size of the plans solving the instance in the target formalism. If a compilation scheme f has the property that for every plan solving an instance there exists a plan solving F () such that jj jj  jj jj k for some positive integer constant k, f is a **compilation scheme preserving plan size exactly** (up to additive constants). If jj jj  c - jj jj k for positive integer constants c and k, then f is a **compilation**
scheme preserving plan size linearly, and if jj jj  p jj jj; jj jj for some polynomial p, then f is a **compilation scheme preserving plan size polynomially**. More generally, we say that a planning formalism X is **compilable** to formalism Y (in polynomial time, preserving plan size exactly, linearly, or polynomially), if there exists a compilation scheme with the appropriate properties. We write X xY in case X is compilable to Y or X x p Y if the compilation can be done in polynomial time. The super-script x can be , c, or p depending on whether the scheme preserves plan size exactly, linearly plan, or polynomially, respectively.

As is easy to see, all the notions of compilability introduced above are reflexive and transitive.