In order to simulate the parallel behavior of conditional effects, we have to break them up into individual operators that are executed sequentially. This means that for each conditional effect of an operator we introduce two new operators. One simulates the successful application of the rule, the other one simulates the "blocking" situation of the rule. At least one of these operators must be executed for each conditional effect in the original operator. This is something we can force by additional literals that are added to control the execution of operators. All in all this leads to a sequence of operators that has length bounded by the number of conditional effects in the original operator.

If we want to simulate the parallel behavior by a sequence of unconditional operators, the effects of the unconditional operators should not directly influence the state description, but the effect should be deferred until all operators corresponding to the set of conditional effects have been executed. For this reason, we will use a sequence of "copying operators" which copy the activated effects to the state description after all "conditional operators" have been executed. These "copying operators" can also be used to check that the set of activated effects is consistent. Theorem 20 SBIC *can be compiled to* SBI *in polynomial time preserving plan size polynomially.*
Proof. Assume that h ; Oi is the SBIC source domain structure and assume further, without loss of generality (using a polynomial transformation), that all operators have the form

$${\bf\hat{\Phi}}>\;l_{i,m_{i}}$$

oi hpre oi ; 'i;1 ) l i;1; : : : ; 'i;mi ) li;mi gi; with 'i;j , l i;j , and l i;j 6 l i;k for i 6 k.

Let + and  be disjoint copies of , which are used to record the active effects of conditional effects, and let \# be another disjoint copy, which is used to record that an active effect has not been copied yet. Further, let O po o O be a new set of atoms corresponding one-to-one to the operators in O and let  be a set of symbols corresponding one-to-one to all conditional effects in O, i.e.,
 xi;j 'i;j ) l i;j *post* oi ; oi O :
Finally, let c be a fresh atom not appearing in +  \# O that signals that copying the active effects to the state specification is in progress. The set of symbols for the compiled domain structure is then

$$x_{i,j}\;\;\;\varphi_{i,j}\,\Rightarrow\,\iota_{i,j}$$
$\sigma$  2. 
$$\mathbf{O}$$
$${\vec{\pi}}{\vec{\pi}}$$
$\underline{\hphantom{\underline{a}}}$
$$\mathbf{0}\quad\quad\quad c\ \ ,\quad p_{o_{i}}$$
+  # O  c :
For each operator oi O, the compilation scheme introduces a number of new operators. The first operator we introduce is one which checks whether the conditional effects of the previous operators have all been executed, no copying is in progress and the precondition is satisfied. If this is the case, the execution of the conditional effects for this operator is started:

$$\sigma_{i}^{p r e}$$
$$\langle p r e\ o_{i}$$

pre
i hpre oi O f:c ; poi +   #i:
This operator enables all the "conditional effect operators." For the activated effects, we introduce the following operators:

$\varphi_{i}^{\,\Rightarrow\,i,j}$$\langle$$p_{o_{i}}$$\varphi_{i,j}$$,$$x_{i,j}$$p_{+},p_{\,\#}$$p$$l_{i,j}$$p_{-},p_{\,\#}$$p$$l_{i,j}$$\rangle$.  

$$\nwarrow\rangle\,.$$