
## 6.4 Parallel Execution Models And The Feasibility Of Compilation Schemes Preserving Plan Size Polynomially

While compilation schemes that preserve plan size exactly or linearly seem to be of immediate use, a polynomial growth of the plan appears to be of little practical interest. Considering the practical experience that planning algorithms can roughly be characterized by their property of how many steps they can plan without getting caught by the combinatorial explosion and the fact that this number is significantly smaller than 100, polynomial growth does not seem to make much sense.

If we take GRAPHPLAN (Blum & Furst, 1997) into consideration again—the planning system that motivated our investigation in the first place—it turns out that this system allows for the parallel execution of actions. Although parallel execution might seem to add to the power of the planning system considerably, it does not affect our results at all. If a sequential plan can solve a planning instance with n steps, a parallel plan will also need at least n actions. Nevertheless, although the size of a plan (measured in the number of operations) might be the same, the number of time steps may be considerably smaller—which might allow for a more efficient generation of the plan. Having a look at the compilation scheme that compiles conditional effects away, it seems to be the case that a large number of generated actions could be executed in parallel—in particular those actions that simulate the conditional effects.

However, the semantics of parallel execution in GRAPHPLAN is quite restrictive. If one action adds or deletes an atom that a second action adds or deletes or if one action deletes an atom that a second action has in its precondition, then these two actions cannot be executed in parallel in GRAPHPLAN. With this restriction, it seems to be impossible to compile conditional effects away preserving the number of time steps in a plan. However, a compilation scheme that preserves the number of time steps linearly seems to be possible. Instead of such a compilation scheme, the approaches so far either used an exponential translation (Gazen & Knoblock, 1997) or modified the GRAPHPLAN-algorithm in order to handle conditional effects (Anderson et al., 1998; Koehler et al.,
1997; Kambhampati et al., 1997). These modifications involve changes in the semantics of parallel execution as well as changes in the search procedure. While all these implementations are compared with the straightforward translation Gazen and Knoblock (1997) used, it would also be interesting to compare them with a compilation scheme based on the ideas spelled out in Theorem 22 as the base line.

## 7. Summary And Discussion

Motivated by the recent approaches to extend the GRAPHPLAN algorithm (Blum & Furst, 1997) to deal with *more expressive planning formalisms* (Anderson et al., 1998; Gazen & Knoblock, 1997; Kambhampati et al., 1997; Koehler et al., 1997), we asked what the term *expressive power* could mean in this context. One reasonable intuition seems to be that the term *expressive power* refers to how concisely domain structures and the corresponding plans can be expressed. Based on this intuition and inspired by recent approaches in the area of knowledge compilation (Gogic et al., 1995; Cadoli et al., 1996; Cadoli & Donini, 1997), we introduced the notion of *compilability* in order to measure the relative expressiveness of planning formalisms. The basic idea is that a compilation scheme can only transform the domain structure, i.e., the symbol set and the operators, while the initial state and the goal specification are not transformed—modulo some small changes necessary for technical reasons. Further, we distinguish compilation schemes according to whether the plan in the target formalism has the same size (up to an additive constant), a size bounded linearly by the