If we allow for polynomial growth of the plans in the target formalism, then all formalisms not containing incomplete state specifications and boolean formulae are compilable to each other. Incomplete state specifications together with boolean formulae, however, seem to add significantly to the expressiveness of a planning formalism, since these cannot be compiled away even when allowing for polynomial growth of the plan and unbounded resources in the compilation process.

It should be noted, however, that some of these results hold only if we use the semantics for conditional effects over partial state specifications as spelled out in Section 2.1. For other semantics, we may get slightly different results concerning the compilability of conditional effects over partial states.

One question one may ask is what happens if we consider formalisms with boolean formulae that are syntactically restricted. As indicated at various places in the paper, restricted formulae, such as CNF or DNF formulae, can sometimes be easily compiled away. However, there are also cases when this is impossible. For example, it can be shown that CNF formulae cannot be compiled to basic STRIPS preserving plan size linearly (Nebel, 1999), which confirms B¨ackstr¨om's (1995)
conjecture that CNF-formulae in preconditions add to the expressive power of basic STRIPS.

Another question is how reasonable our restrictions on a compilation scheme are. In particular, one may want to know whether *non-modular* state-translation functions could lead to more powerful compilation schemes. First of all, requiring that the state-translation functions are modular seems to be quite weak considering the fact that a compilation scheme should only be concerned with the domain structure and that the initial state and goal specification should not be transformed at all. Secondly, considering the fact that the state-translation functions do not depend on the operator set, more complicated functions seem to be useless. From a more technical point of view, we need modularity in order to prove that conditional effects and boolean formulae cannot be compiled away preserving plan size linearly. For the conditional effects, modularity or a similar condition seems to be crucial. For the case of boolean formulae, we could weaken the condition to the point that we require only that state-translation functions are computable by circuits of constant depth—or something similar. In any case, the additional freedom one gets from non-modular state-translation functions does not seem to be of any help because these functions do not take the operators into account. Nevertheless, it seems to be an interesting theoretical problem to prove that more powerful state-translation functions do not add to the power of compilation schemes.

Although the paper is mainly theoretical, it was inspired by the recent approaches to extend the GRAPHPLAN algorithm to handle more powerful planning formalisms containing conditional effects. So, what are the answers we can give to open problems in the field of planning algorithm design? First of all, Gazen and Knoblock's (1997) approach to compiling conditional effects away is optimal if we do not want to allow plan growth more than by a constant factor. Secondly, all of the other approaches (Anderson et al., 1998; Kambhampati et al., 1997; Koehler et al., 1997) that modify the GRAPHPLAN algorithm are using a strategy similar to a polynomial-time compilation scheme preserving plan size polynomially. For this reason, these approaches should be compared to a "pure compilation approach" using the ideas from the compilation scheme developed in the proof of Theorem 22 as the base line. Thirdly, allowing for unrestricted boolean formulae adds again a level of expressivity because they cannot be compiled away with linear growth of the plan size. In fact, approaches such as the one by Anderson and colleagues (1998) simply expand the formulae to DNF accepting an exponential blow-up. Again, we cannot do better than that if plan size should be preserved linearly. Fourthly, if we want to add partial state specifications on top of general boolean formulae, this would amount to an increase of expressivity that is much larger than