semantics of the rules. Second, we introduce two approaches to rule specification. Third, we present the rewriting algorithm, its formal properties, and the complexity of plan rewriting. Finally, we present a taxonomy of plan-rewriting rules.

## 3.1.1  P Lan - R Ewriting  R U L E S :  S Y N Tax And S Emantics

First, we introduce the rule syntax and semantics through some examples. Then, we provide a formal description. A plan-rewriting rule has three components: (1) the antecedent ( : if field) specifies a subplan to be matched; (2) the :replace field identifies the subplan that is going to be removed, a subset of steps and links of the antecedent; (3) the : with field specifies the replacement subplan. Figure 6 shows two rewriting rules for the Blocks World domain introduced in Figure 2. Intuitively, the rule avoid-move-twice says that, whenever possible, it is better to stack a block on top of another directly, rather than first moving it to the table. This situation occurs in plans generated by the simple algorithm that first puts all blocks on the table and then build the desired towers, such as the plan in Figure 4. The rule avoid-undo says that the actions of moving a block to the table and back to its original position cancel each other and both could be removed from a plan.

(define-rule :name avoid-move-twice
(define-rule :name avoid-undo
:if (:operators ((?n1 (unstack ?b1 ?b2))
: if (:operators
(?n2 (stack ?b1 ?b3 Table)))
(?n1 (unstack ?b1 ?b2))
:links (?n1 (on ?b1 Table) ?n2)
:constraints ((possibly-adjacent ?n1 ?n2)
(:neq ?b2 ?b3)))
:replace (:operators (?n1 ?n2))
:with (:operators (?n3 (stack ?b1 ?b3 ?b2))))

| (?n2 (stack ?b1 ?b2 Table)))    |
|---------------------------------|
| : c o n s t r a i n t s         |
| (possibly-adjacent ?n2))        |
| :replace (:operators (?n1 ?n2)) |
| : w i t h N I L ) )             |

A rule for the manufacturing domain of (Minton, 1988b) is shown in Figure 7.  This domain and additional rewriting rules are described in detail in Section 4.1.  The rule states that if a plan includes two consecutive punching operations in order to make holes in two different objects, but another maine, a drill-press, is also available, the plan quality may be improved by replacing one of the punch operations with the drill-press. In this domain the plan quality is the (parallel) time to manufacture all parts.  This rule helps to parallelize the plan and thus improve the plan quality.

(define-rule :name punch-by-drill-press
:if (:operators ((?n1 (punch ?o1 ?width1 ?orientation1))
(?n2 (punch ?o2 ?width2 ?orientation2)))
:links (?n1 ?n2)
:constraints ((:neq ?ol ?o2)
(possibly-adjacent ?n1 ?n2)))
: replace (: operators (?n1))
:with (:operators (?n3 (drill-press ?o1 ?width1 ?orientation1)))
Figure 7: Manufacturing Process Planning Rewriting Rule