The plan-rewriting rule syntax is described by the BNF specification given in Figure 8.

This BNF generates rules that follow the template shown in Figure 9. Next, we describe the semantics of the three components of a rule ( : if , : replace , and : with fields ) in detail.

<rule> ::= (define-rule :name <name>
:if (<graph-spec-with-constraints>)
:replace (<graph-spec>)
:with (<graph-spec>))
<graph-spec-with-constraints> ::= {<graph-spec>}
{ : c o n s t r a i n t s   ( < c o n s t r a i n t s >) }
<graph-spec> ::= {:operators (<nodes>)}
{:links (<edges>)} | NIL
<nodes> ::= <node> | <node> <nodes> <edges> ::= <edge> | <edge> <edges>
<constraints> ::= <constraint> | <constraint> <constraints> <node> ::= (<node-var> {<node-predicate>} {:resource})
<edge> ::= (<node-var> <node-var>) |
(node-var> <edge-predicate> <node-var>) |
(node-var> :threat <node-var>)
<constraint> ::= <interpreted-predicate> |
(:neq <pred-var> <pred-var>)
<node-var> n <pred-var> = 0, {} = optional, | = alternative Figure 8: BNF for the Rewriting Rules
(define-rule :name <rule-name>
:if (:operators ((<nv> <np> {:resource}) ...)
:links ((<nv> {<lp>|:threat} <nv>) ...) :constraints (<ip> ...))
:replace (:operators (<nv> ..

:links ((<nv> {<lp>|:threat} <nv>) ...))
:with (:operators ((<nv> <np> {:resource}) ...)
:links ((<nv> {<lp>} <nv>) ...)))
<nv> = node variable, <np> = node predicate, {} = optional | = alternative
<lp> = causal link predicate, <ip> = interpreted predicate, The antecedent, the :if field, specifies a subplan to be matched against the current plan. The graph structure of the subplan is defined in the :operators and :links fields. The :operators field specifies the nodes (operators) of the graph and the :links field specifies the edges (causal and ordering links). Finally, the :constraints field specifies a set of constraints that the operators and links must satisfy.

The :operators field consists of a list of node variable and node predicate pairs. The step number of those steps in the plan that match the given node predicate would be correspondingly bound to the node variable. The node predicate can be interpreted in two ways: as the step action, or as a resource used by the step. For example, the node ssseeeeerrrreeerrreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerrreeeerrreeeerrreeeerrreeeerrreeeerrreeeerrrreeeerrrreeeerrrreeee            
Figure 6 shows a node predicate that denotes a step action. This node specification will collect tuples, composed of step number ?n2 and blocks ?b1 and ?b3, obtained by matching steps whose action is a stack of a block ?b1 that is on the Table and it is moved on top of another block ?b3. This node specification applied to the plan in Figure 4 would result in