procedure RewritePlan Input : a valid partial-order plan P
a rewriting rule R = (qm; Pr; Pc); Variables(pr) ⊆ Variables(qm)
Output : a valid rewritten partial-order plan P ′ (or failure) 1. Σ := Match(gm,P)
Match the rule antecedent qm ( : if field) against P . The result is a set of substitutions Σ = {...,σi, ...} for variables in qm .

2. If Σ = ∅ then return failure 3. Choose a match σ i ∈ Σ

4. p r := o p r Instantiate the subplan to be removed pr (the :replace field) according to σ i .

5. Pi := AddFlaws(UsefulEffects(pi,), P - pi,)
Remove the instantiated subplan p i , from the plan P and add the UsefulEffects of p i as open conditions. The resulting plan P r is now incomplete.

6. p c := σ i p c
Instantiate the replacement subplan pc (the : with field) according to σi.

7. P i := AddFlaws(Preconditions(p i ) ∪ FindThreats(P, ∪ p i ), P, ∪ p i )
Add the instantiated replacement subplan p c to P r . Find new threats and open conditions and add them as flaws. P c is potentially incomplete, having several flaws that need to be resolved.

8. P ′ := rPOP (P ′ )
Complete the plan using a partial-order causal-link planning algorithm (restricted to do only step reuse, but no step addition) in order to resolve threats and open conditions.

r POP returns failure if no valid plan can be found.

9. Return Pl

## Figure 13: Plan-Rewriting Algorithm

The result is the partial plan Pj (line 5).  Continuing with our example, Figure 14(a) shows the plan resulting from removing steps 1 and 4 from the plan in Figure 4.

Finally, the algorithm embeds the instantiated replacement subplan p c into the remainder of the original plan (lines 6-9). If the rule is completely specified, the algorithm simply adds the (already instantiated) replacement subplan to the plan, and no further work is nnecessary. If the rule is partially specified, the algorithm computes the embeddings of the replacement subplan into the remainder of the original plan in three stages. First, the algorithm adds the instantiated steps and links of the replacement plan p c (line 6) into the current partial plan P t (line 7). Figure 14(b) shows the state of our example after p c , the new stack step (6), has been incorporated into the plan. Note the open conditions
(clear A) and on(C D). Second, the FindThreats procedure computes the possible threats, both operator threats and resource conflicts, occurring in the Pj Upj partial plan (line 7); for example, the threat situation on the clear(C) proposition between step 6 and 2 in Figure 14(b). These threats and the preconditions of the replacement plan p i are recorded by AddFlaws resulting in the partial plan P c . Finally, the algorithm completes the plan using rPOP, a partial-order causal-link planning procedure restricted to only reuse steps (i.e., no