our plans could be easily described in datalog. For example, the possibly-adjacent interpreted predicate of Figure 7 could be described declaratively as a datalog program instead of a piece of code.  In summary, rule match for moderately sized rules, even for quite expressive languages and large plans, remains tractable and can be made efficient using production match (Forgy, 1982) and query optimization techniques (Sellis, 1988).

The second source of complexity is computing the embeddings of the replacement plan given in the consequent of a plan-rewriting rule. By the definition of full-specification rules, the embedding is completely specified in the rule itself. Thus, it suffices simply to remove the undesired subplan and directly add the replacement subplan. This is linear in the size of the consequent.

For partial-specification rules, computing all the embeddings of the replacement subplan can be exponential in the size of the plan in the worst case. However, this occurs only in pathological cases. For example, consider the plan in Figure 15(a) in which we are going to compute the embeddings of step x into the remainder of the plan in order to satisfy the open precondition g0. Step x has no preconditions and has two effects ¬b and g0. Each step in the plan has proposition b as an effect. Therefore, the new step x conflicts with every step in the plan (1 to n) and has to be ordered with respect to these steps. Unfortunately, there are an exponential number of orderings.  In effect, the orderings imposed by adding the step x correspond to all the partitions of the set of steps (1 to n) into two sets: one ordered before x and one after. Figure 15(b) shows one of the possible orderings. If the subplan we were embedding contained several steps that contained similar conflicts the problem would be compounded. Even deciding if a single embedding exists is NP-hard. For example, if we add two additional effects ¬a and ¬g1 to operator x, there is no valid embedding.  In the worst case (solving first the flaws induced by the conflicts on proposition b) we have to explore an exponential number of positions for step x in the plan, all of which end up in failure. Nevertheless, given the quasi-decomposability of useful planning domains we expect the number of conflicts to be relatively small. Also most of the useful rewriting rules specify replacement subplans that are small compared with the plan they are embedding into.  Our experience indicates that plan rewriting with partial-specification rules can be performed efficiently as shown by the results of Section 4.

![0_image_0.png](0_image_0.png)

