HSP (Bonet, Loerincs, & Geffner, 1997; Bonet & Geffner, 1999) is a forward search planner that performs a variation of heuristic search applied to classical AI planning. The built-in heuristic function is a relaxed version of the planning problem: it computes the number of required steps to reach the goal disregarding negated effects in the operators.

Such metric can be computed efficiently. Despite its simplicity and that the heuristic is not admissible, it scales surprisingly well for many domains. Because the plans are generated according to the fixed heuristic function, the planner cannot incorporate a quality metric.

These types of planners are quite efficient in practice although they often produce suboptimal plans. They are excellent candidates to generate the initial plans that will be subsequently optimized by PbR.

## 3.4.2 Facilitating Algorithmic Plan Construction

For many domains, simple domain-dependent approximation algorithms will provide good initial plans. For example, in the query planning domain, the system can easily generate initial query evaluation plans by randomly (or greedily) parsing the given query. In the Blocks World it is also straightforward to generate a solution in linear time using the naive algorithm: put all blocks on the table and build the desired towers from the bottom up.

This algorithm produces plans of length no worse than twice the optimal, which makes it already a good approximation algorithm. However, the interest in the Blocks World has traditionally been on optimal solutions, which is an NP-hard problem (Gupta & Nau, 1992).

Our system facilitates the creation of these initial plans by freeing the user from specifying the detailed graph structure of a plan. The user only needs to specify an algorithm that produces a sequence of instantiated actions, that is, action names and the ground parameters that each action takes. 12 For example, the (user-defined) naive algorithm for the Blocks World domain described above applied to the problem in Figure 4 produces the sequence: unstack(C A), unstack(B D), stack(C D Table), stack(B C Table), and stack(A B Table). Then, the system automatically converts this sequence of actions into a fully detailed partial-order plan using the operator specification of the domain. The resulting plan conforms to the internal data structures that PbR uses. This process includes creating nodes that are fully detailed operators with preconditions and effects, and adding edges that represent all the necessary causal links and ordering constraints. In our Blocks World example the resulting plan is that of Figure 4.

The algorithm that transforms the user-defined sequence of actions into a partial-order plan is presented in Figure 17.  The algorithm first constructs the causal structure of the plan (lines 2 to 6) and then adds the necessary ordering links to avoid threats (lines 7 to 10).

The user only needs to specify action names and the corresponding instantiated action parameters.  Our algorithm consults the operator specification to find the preconditions and effects, instantiate them, construct the causal links, and check for operator threats.

Operator threats are always resolved in favor of the ordering given by the user in the input plan. The reason is that the input plan may be overconstrained by the total order, but it is assumed valid. Therefore, by processing each step last to first, only the orderings that indeed avoid threats are included in the partial-order plan.