
## 4.1   Manufacturing  Process  Planning

The task in the manufacturing process planning domain is to find a plan to manufacture a set of parts. We implemented a PbR translation of the domain specification in (Minton, 1988b). This domain contains a variety of machines, such as a lathe, punch, spray painter, welder, etc, for a total of ten machining operations. The operator specification is shown in Figures 18 and 19. The features of ea part are described by a set of predicates, su as temperature, painted, has-hole, etc. These features are changed by the operators.  Other predicates in the state, such as has-clamp, is-drillable, etc, are set in the initial state of each problem.

As an example of the behavior of an operator, consider the polish operator in Figure 18.

It requires the part to manufacture to be cold and that the polisher has a clamp to secure the part to the machine. The effect of applying this operator is to leave the surface of the part polished. Some attributes of a part, such as surface-condition, are single-valued, but others, like has-hole, are multivalued. Note how the drill-press and the punch operators in Figure 18 do not prevent several has-hole conditions from being asserted on the same part. Other interesting operators are weld and bolt. These operators join two parts in a particular orientation to form a new part. No further operations can be performed on the separate parts once they have been joined.

The measure of plan cost is the schedule length, the (parallel) time to manufacture all parts. In this domain all of the machining operations are assumed to take unit time. The machines and the objects (parts) are modeled as resources in order to enforce that only one part can be placed on a machine at a time and that a machine can only operate on a single part at a time (except bolt and weld which operate on two parts simultaneously).

We have already shown some of the types of rewriting rules for this domain in Figures 7 and 10. The set of rules that we used for our experiments is shown in Figure 20.  The top eight rules are quite straightforward once one becomes familiar with this domain. The two top rules explore the space of alternative orderings originated by resource conflicts. The machine-swap rule allows the system to explore the possible orderings of operations that require the same machine. This rule finds two consecutive operations on the same machine and swaps their order. Similarly, the rule object-swap allows the system to explore the orderings of the operations on the same object.  These two rules use the interpreted predicate adjacent-in-critical-path to focus the attention on the steps that contribute to our cost function. Adjacent-in-critical-pathchecks if two steps are consecutive along one of the critical paths of a schedule. A critical path is a sequence of steps that take the longest time to accomplish. In other words, a critical path is one of the sequences of steps that determine the schedule length.

The next six rules exchange operators that are equivalent with respect to achieving ssseeeerrrreeerrreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerreeerrreeerrreeerrreeerrreeerrreeerrreeerrreeerrreeerrreeerrrreeerrrreeerrrreeerrrr and spray-paint operators. By examining the operator definitions in Figure 19, it can be readily noticed that both operators change the value of the painted predicate. Similarly, PU-by-DP and DP-by-PU exchange drill-press and punch operators, which produce the has-hole predicate. Finally, roll-by-lathe and lathe-by-rollexchange roll and lathe operators as they both can make parts cylindrical. To focus the search on the most promising