(:not (surface-condition ?x ?surf)))
(surface-condition ?x POLISHED)))
(define (operator LATHE)
:parameters (?x) :resources ((machine LATHE) (is-object ?x))
:precondition (is-object ?x) :effect
(:and (:forall (?color)
(:not (painted ?x ?color)))
( : f o r a l l  ( ?s ha p e )
(: when (:neq ?shape CYLINDRICAL)
(:not (shape ?x ?shape))))
( : f o r a l l  ( ? s u r f )
(: when (:neq ?surf ROUGH)
(:not (surface-condition ?x ?surf))))

| (have-bit ?width)                          |         |
|--------------------------------------------|---------|
| (is-drillable ?x ?orientation))            | :effect |
| :effect (has-hole ?x ?width ?orientation)) |         |

(surface-condition ?x ROUGH)
(shape ?x CYLINDRICAL))
(define (operator DRILL-PRESS)
:parameters (?x ?width ?orientation)
:resources ((machine DRILL-PRESS)
(is-object ?x))
:precondition
(:and (is-object ?x)
(:not (surface-condition ?x ?surf))))
(define (operator ROLL)
:parameters (?x) :resources ((machine ROLLER) (is-object ?x))
:precondition (is-object ?x) :effect
(:and (:forall (?color)
(:not (painted ?x ?color)))
( : f o r a l l  ( ? s h a p e )
(: when (:neq ?shape CYLINDRICAL)
(:not (shape ?x ?shape))))
( :forall ( ?temp )

| (define (operator GRIND)                      |
|-----------------------------------------------|
| :parameters (?x)                              |
| :resources ((machine GRINDER) (is-object ?x)) |
| :precondition (is-object ?x)                  |
| :effect                                       |
| (:and (:forall (?color)                       |
| (:not (painted ?x ?color)))                   |
| ( f o r a l l  ( ? s u r f )                  |
| (: when (:neq ?surf SMOOTH)                   |
| (:not (surface-condition ?x ?surf))))         |
| (surface-condition ?x SMOOTH))                |

(: when (:neq ?temp HOT)
(:not (temperature ?x ?temp))))
( f o r a l l  ( ? s u r f )
(:not (surface-condition ?x ?surf)))
( : f o r a l l ( ? w i d t h  ? o r i e n t a t i o n )
( : not ( has-hole ?x ?width ?orientation ))
(temperature ?x HOT)
(shape ?x CYLINDRICAL))
(define (operator PUNCH)
:parameters (?x ?width ?orientation)
:resources ((machine PUNCH) (is-object ?x)) :precondition
(:and (is-object ?x)
(ha s -c la mp PUNCH)
(is-punchable ?x ?width ?orientation))
:effect
(:and (:forall (?surf)
(: when (:neq ?surf ROUGH)
(:not (surface-condition ?x ?surf))))
(surface-condition ?x ROUGH)
(has-hole ?x ?width ?orientation)))
exchanges these rules only match operators in the critical path (by means of the interpreted predicate in-critical-path).

The six bottom rules in Figure 20 are more sophisticated. The lathe+SP-by-SP rule

| (define (operator POLISH)                      |
|------------------------------------------------|
| :parameters (?x)                               |
| :resources ((machine POLISHER) (is-object ?x)) |
| :precondition (:and (is-object ?x)             |
| (temperature ?x COLD)                          |
| (has-clamp POLISHER))                          |
| :effect                                        |
| (:and (:forall (?surf)                         |
| (: when (:neq ?surf POLISHED)                  |

takes care of an undesirable effect of the simple depth-first search used by our initial plan generator. In this domain, in order to spray paint a part, the part must have a regular shape. Being cylindrical is a regular shape, therefore the initial planner may decide to make the part cylindrical by lathing it in order to paint it! However, this may not be necessary as the part may already have a regular shape (for example, it could be rectangular, which is also a regular shape). Thus, the lathe+SP-by-SP substitutes the pair spray-paint and lathe by a single spray-paint operation. The supporting regular-shapes interpreted predicate