
| (define (operator IMMERSION-PAINT)         |
|--------------------------------------------|
| :parameters (?x ?color)                    |
| :res our ces ((ma chine IMMERSION-PAINTER) |
| (is-object ?x))                            |
| :precondition                              |
| (:and (is-object ?x)                       |
| (have-paint-for-immersion ?color))         |
| :effect (painted ?x ?color))               |
| (define (operator WELD)                    |
| :parameters (?x ?y ?new-obj ?orient)       |
| :resources ((machine WELDER)               |
| (is-object ?x) (is-object ?y))             |
| :precondition                              |

(:and (is-object ?x) (is-object ?y)
(composite-object ?new-obj ?orient ?x ?y)
(can-be-welded ?x ?y ?orient))
:effect (:and (temperature ?new-obj HOT)
(joined ?x ?y ?orient)
(:not (is-object ?x))
(:not (is-object ?))))

| (define (operator SPRAY-PAINT)              |
|---------------------------------------------|
| :parameters (?x ?color ?shape)              |
| :resources ((machine SPRAY-PAINTER)         |
| (is-object ?x))                             |
| :precondition (:and (is-object ?x)          |
| (sprayable ?color)                          |
| (temperature ?x COLD)                       |
| (regular-shape ?shape)                      |
| (shape ?x ?shape)                           |
| (has-clamp SPRAY-PAINTER))                  |
| :effect (painted ?x ?color))                |
| (define (operator BOLT)                     |
| :parameters (?x ?y ?new-obj ?orient ?width) |
| :resources ((machine BOLTER)                |
| (is-object ?x) (is-object ?y))              |
| :precondition                               |
| (:and (is-object ?x) (is-object ?y)         |

(composite-object ?new-obj ?orient ?x ?y)

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

(has-hole ?x ?width ?orient)
(has-hole ?y ?width ?orient)
(bolt-width ?width)
(can-be-bolted ?x ?y ?orient))
:effect (:and (:not (is-object ?x))

![0_image_2.png](0_image_2.png)

(:not (is-object ?))
(joined ?x ?j ?orient)))
just enumerates which are the regular shapes. These rules are partially specified and are not guaranteed to always produce a rewriting. Nevertheless, they are often successful in producing plans of lower cost.

The remaining rules explore bolting two parts using bolts of different size if fewer operations may be needed for the plan. We developed these rules by analyzing differences in the quality of the optimal plans and the rewritten plans. For example, consider the both-providers-diff-bolt rule. This rule states that if the parts to be bolted already have compatible holes in them, it is better to reuse those operators that produced the holes. The initial plan generator may have drilled (or punched) holes whose only purpose was to bolt the parts. However, the goal of the problem may already require some holes to be performed on the parts to be joined. Reusing the available holes produces a more economical plan. The rules has-hole-x-diff-bolt-add-PU, has-hole-x-diff-bolt-add-DP, has-hole-y-diff-bolt-add-PU, and has-hole-y-diff-bolt-add-DP address the cases in which only one of the holes can be reused, and thus an additional punch or drill-press operation needs to be added.

As an illustration of the rewriting process in the manufacturing domain, consider Figure 21. The plan at the top of the figure is the result of a simple initial plan generator that solves each part independently and concatenates the corresponding subplans.  Although such plan is generated efficiently, it is of poor quality. It requires six time-steps to manufacture all parts. The figure shows the application of two rewriting rules, machine-swap and IP-by-SP, that improve the quality of this plan. The operators matched by the rule antecedent are shown in italics . The operators introduced in the rule consequent are shown in bold. First, the machine-swap rule reorders the puning operations on parts A and B. This