300 allows 300 plateau plans. Note that the limit is across all plateaus encountered during the search for a problem, not for each plateau.

We tested each of the four systems on 200 problems, for machining 10 parts, ranging from 5 to 50 goals. The goals are distributed randomly over the 10 parts. So, for the 50goal problems, there is an average of 5 goals per part. The results are shown in Figure 22.

In these graphs each data point is the average of 20 problems for each given number of goals. There were 10 provably unsolvable problems. Initial and PbR solved all 200 problems (or proved them unsolvable). IPP solved 65 problems in total: all problems at 5 and 10 goals, 19 at 15 goals, and 6 at 20 goals. IPP could not solve any problem with more than 20 goals under the 1000 CPU seconds time limit.

Figure 22(a) shows the average time on the solvable problems for each problem set for the four planners. Figure 22(b) shows the average schedule length for the problems solved by all the planners, that is, over the 65 problems solved by IPP up to 20 goals.  The fastest planner is Initial, but it produces plans with a cost of about twice the optimal. IPP
produces the optimal plans, but it cannot solve problems of more than 20 goals. The two configurations of PbR scale much better than IPP solving all problems and producing good quality plans. PbR-300 matches the optimal cost of the IPP plans, except in one problem
(the reason for the difference is interesting and we explain it below). The faster PbR-100 also stays very close to the optimal (less than 2.5% average cost difference).

Figure 22(c) shows the average sedule length for the problems solved by each of the planners for the 50 goal range. The PbR configurations scale gracefully across this range improving considerably the cost of the plans generated by Initial.  The additional exploration of PbR-300 allows it to improve the plans even further. The reason for the difference between PbR and IPP at the 20-goal complexity level is because the cost results for IPP are only for the 6 problems that it could solve, while the results for PbR and Initial are the average of all of the 20 problems (as shown in Figure 22(b), PbR matches the cost of these 6 optimal plans produced by IPP).

Figure 22(d) shows the average number of operators in the plans for the problems solved by all three planners (up to 20 goals). Figure 22(e) shows the average number of operators in the plans for the problems solved by each planner across the whole range of 50 problems.

The plans generated by Initial use about 2-3 additional operators.  Both PbR and IPP
produce plans that require fewer steps. Interestingly, IPP sometimes produces plans that use more operations than PbR. IPP produces the shortest parallel plan, but not the one with the minimum number of steps. In particular, we observed that some of the IPP plans suffer from the same problem as Initial. IPP would also lathe a part in order to paint it, but as opposed to Initial it would only do so if it did not affect the optimal schedule length. Surprisingly, adding such additional steps in this domain may improve the schedule length, albeit in fairly rare situations. This was the case in the only problem in which IPP
produced a better schedule than PbR-300. We could have introduced a rewriting rule that ssss for such cases. However, such rule is of very low utility (in the sense of Minton, 1988b).

It expands the rewriting search space, adds to the cost of match, and during the random search provides some benefit very rarely.