This experiment illustrates the flexibility of PbR in specifying complex rules for a planning domain. The results show the benefits of finding a suboptimal initial plan quickly and then efficiently transforming it to improve its quality.

## 4.2 Logistics

The task in the logistics domain is to transport several packages from their initial location to their desired destinations. We used a version of the logistics-strips planning domain of the AIPS98 planning competition whi we restricted to using only trus but not planes. 14 The domain is shown in Figure 23. A package is transported from one location to another by loading it into a truck, driving the truck to the destination, and unloading the truck. A truck can load any number of packages. The cost function is the (parallel) time to deliver all packages (measured as the number of operators in the critical path of a plan).

(define (operator LOAD-TRUCK)
(define (operator UNLOAD-TRUCK)
:parameters (?obj ?truck ?loc)
:parameters (?obj ?truck ?loc)
:precondition
:precondition
( :and (obj ?obj) (truck ?truck) (location ?loc)
(:and (obj ?obj) (truck ?truck) (location ?loc)
(at ?truck ?loc) (at ?obj ?loc))
(at ?truck ?loc) (in ?obj ?truck))
:effect (:and (:not (at ?obj ?loc))
:effect (:and (:not (in ?obj ?truck))
(in ?obj ?truck)))
(at ?obj ?loc)))
(define (operator DRIVE-TRUCK)
:parameters (?truck ?loc-from ?loc-to ?city)
:precondition (:and (truck ?truck) (location ?loc-from) (location ?loc-to) (city ?city)
(at ?truck ?loc-frœm) (in-city ?loc-frœm ?city) (in-city ?loc-to ?city))
:effect (:and (:not (at ?truck ?loc-from)) (at ?truck ?loc-to)))
Figure 23: Operators for Logistics We compare three planners on this domain:

## Ipp: Ipp (Koehler Et Al., 1997) Produces Optimal Plans In This Domain.

Initial:  The initial plan generator picks a distinguished location and delivers packages one by one starting and returning to the distinguished location. For example, assume that truck t1 is at the distinguished location 11, and package p1 must be delivered from location 12 to location 13. The plan would be: drive-truck(t1 11 12 c), load-truck(p1 t1 12),
drive-truck(t1 12 13 c), unload-truck(p1 t1 13), drive-truck(t1 13 11 c). The initial plan generator would keep producing these circular trips for the remaining packages. Although this algorithm is very efficient it produces plans of very low quality. PbR:   PbRstarts from the plan produced by Initial and uses the plan rewriting rules shown in Figure 24 to optimize plan quality. The loop rule states that driving to a location and returning ba immediately aer is useless. The fact that the operators must be adjacent is important because it implies that no intervening load or unload was performed. In the same vein, the triangle rule states that it is better to drive directly between two locations than through a third point if no other operation is performed at such point. The