
| (define-rule :name remote-join-eval      | (define-rule :name join-swap       |        |
|------------------------------------------|------------------------------------|--------|
| :if (:operators                          | :if (:operators                    |        |
| (?n1 (retrieve ?query1 ?source))         | (?n1 (join ?q1 ?jc1 ?sq1b))        |        |
| (?n2 (retrieve ?query2 ?source))         | (?n2 (join ?q2 ?jc2 ?sq2a ?sq2b))) |        |
| (?n3 (join ?query ?jc ?query1 ?query2))) | : links (?n2 ?n1)                  |        |
| : constraints                            | : constraints                      |        |
| (capability ?source 'join)))             | (join-swappable                    |        |
| ?q1 ?jc1 ?sq1a ?sq1b                     |                                    |        |
| :replace (:operators (?n1 ?n2 ?n3))      | in                                 |        |
| ?q2 ?jc2 ?sq2a ?sq2b                     |                                    |        |
| : w i t h  ( : o p e r a t o r s         | : in                               |        |
| (?n4 (retrieve ?query ?source))))        | ?q3 ?jc3 ?sq3a ?sq3b               | :: out |
| ?q4 ?jc4 ?sq4a ?sq4b))                   | :: out                             |        |
| :replace (:operators (?n1 ?n2))          |                                    |        |
| : w i t h  ( : ope r a t o r s           |                                    |        |
| (?n3 (join ?q3 ?jc3 ?sq3b))              |                                    |        |
| (?n4 (join ?q4 ?jc4 ?sq4a ?sq4b)))       |                                    |        |
| :links (?n4 ?n3)))                       |                                    |        |

domain queries are expressed as complex terms (Knoblock, 1996), the PbR rules use the interpreted predicates in the :constraints field to manipulate such query expressions. For example, the join-swappable predicate checks if the queries in the two join operators can be exchanged and computes the new subqueries.

Figure 30 shows an example of the local search through the space of query plan rewritings in a simple distributed domain that describes a company. The figure shows alternative query evaluation plans for a conjunctive query that asks for the names of employees, their salaries, and the projects they are working on. The three relations requested in the query
(Employees, Payroll, and Project ) are distributed among two databases (one at the company's headquarters - HQ-db - and another at a branch - Branch-db). Assume that the leftmost plan is the initial plan. This plan first retrieves the Employee relation at the HQ-db and the Project relation at the Branch-db, and then it joins these two tables on the employee name. Finally, the plan retrieves the Payroll relation from the HQ-db and joins it on ssn with the result of the previous join. Although a valid plan, this initial plan is suboptimal. Applying the join-swap rule to this initial plan generates two rewritings. One of them involves a cross-product, which is a very expensive operation, so the system, following a gradient descent search strategy, prefers the other plan. Now the system applies the remote-join-eval rule and generates a new rewritten plan that evaluates the join between the employee and project tables remotely at the headquarters database. This final plan is of much better quality.

We compare the planning efficiency and plan quality of four query planners:
This is the original query planner (Knoblock, 1995, 1996) for the SIMS mediator, Sage:
which performs a best-first search with a heuristic commonly used in query optimization that explores only the space of left join trees. Sage is a refinement planner (Kambhampati, Knoblock, & Yang, 1995) that generates optimal left-tree query plans.

DP:
This is our implementation of a dynamic-programming bottom-up enumeration of query plans (Ono & Lohman, 1990) to find the optimal plan.  Since in our distributed domain subqueries can execute in parallel and the cost function reflects such preference,