As we explained in Section 3.1.4 there may be pathological cases in which the number of embeddings is exponential in the size of the plan or deciding if the embedding exists is NP-hard. However, often we are not interested in finding all rewritings, for example when following a first improvement search strategy. In our experience the average case behavior seems to be much better as was presented in Section 4.

Systematic algorithms for case-based planning (such as Hanks & Weld, 1995) invert the decisions done in refinement planning to find a path between the solution to a similar old problem and the new problem. The rewriting rules in PbR indicate how to transform a solution into another solution plan based on domain knowledge, as opposed to the generic inversion of the refinement operations. Plan rewriting in PbR is done in a very constrained way instead of an open search up and down the space of partial plans. However, the rules in PR may search the space of rewritings non systematically. Such an effect is ameliorated by using local search.

## 6. Discussion And Future Work

This paper has presented Planning by Rewriting, a new paradigm for efficient high-quality domain-independent planning. PbR adapts graph rewriting and local search techniques to the semantics of domain-independent partial-order planning. The basic idea of PbR
consists in transforming an easy-to-generate, but possibly suboptimal, initial plan into a high-quality plan by applying declarative plan-rewriting rules in an iterative repair style.

There are several important advantages to the PbR planning approach. First, PbR is a declarative domain-independent framework, which brings the benefits of reusability and extensibility. Second, it addresses sophisticated plan quality measures, while most work in domain-independent planning has not addressed quality or does it in very simple ways.

Third, PbR is scalable because it uses efficient local search methods. Finally, PbR is an anytime planning algorithm that allows balancing planning effort and plan quality in order to maximize the utility of the planning process.

Planning by Rewriting provides a domain-independent framework for local search. PbR
accepts declarative domain specifications in an expressive operator language, declarative plan-rewriting rules to generate the neighborhood of a plan, complex quality metrics, interchangeable initial plan generators, and arbitrary (local) search methods.

Planning by Rewriting is well suited to mixed-initiative planning. In mixed-initiative planning, the user and the planner interact in defining the plan. For example, the user can specify which are the available or preferred actions at the moment, change the quality criteria of interest, etc. In fact, some domains can only be approached through mixed-initiative planning. For example, when the quality metric is very expensive to evaluate, such as in geometric analysis in manufacturing, the user must guide the planner towards good quality plans in a way that a small number of plans are generated and evaluated.  Another example is when the plan quality metric is multi-objective or changes over time. Several characteristics of PbR support mixed-initiative planning. First, because PbR offers complete plans, the user can easily understand the plan and perform complex quality assessment.  Second, the rewriting rule language is a convenient mechanism by which the user can propose modifications to the plans. Third, by selecting which rules to apply or their order of application the user can guide the planner.