Our framework achieves a balance between domain knowledge, expressed as plan-rewriting rules, and general local-search techniques that have proved useful in many hard combinatorial problems. We expect that these ideas will push the frontier of solvable problems for many practical domains in which high quality plans and anytime behavior are needed.

The planning style introduced by PbR opens several areas for future research.  There is great potential for applying machine learning techniques to PbR. An important issue is the generation of the plan-rewriting rules.  Conceptually, plan-rewriting rules arise from the chosen plan equivalence relation. All valid plans that achieve the given goals in a finite nmber of steps, i.e. all solution plans, are (satisfiability) equivalent. Each rule arises from a theorem that states that two subplans are equivalent for the purposes of aieving some goals, with the addition of some conditions that indicate in which context that rule can be usefully applied. The plan-rewriting rules can be generated by automated procedures. The methods can range from static analysis of the domain operators to analysis of sample equivalent plans that achieve the same goals but at different costs. Note the similarity with methods to automatically infer search control and domain invariants (Minton, 1988b; Etzioni, 1993; Gerevini & Schubert, 1998; Fox & Long, 1998; Rintanen, 2000), and also the nno to deal with the utility problem. Ambite, Knoblock, & Minton (2000) present some results on learning plan rewriting rules based on comparing initial and optimal plans for smple problems.

Beyond learning the rewriting rules, we intend to develop a system that can automatically learn the optimal planner configuration for a given planning domain and problem distribution in a manner analogous to Minton's Multi-TAC system (Minton, 1996).  Our ssssssssssssse candidate sets of rewriting rules and different search methods. By testing each proposed configuration against a training set of simple problems, the system would hill-climb in the configuration space in order to arrive at the most useful rewriting rules and search strategies for the given planning domain and distribution of problems.

There are many advanced techniques in the local search literature that can be adapted and extended in our framework. In particular, the idea of variable-depth rewriting leads naturally to the creation of rule programs, which specify how a set of rules are applied to a plan. We have already seen how in query planning we could find transformations that are better specified as a program of simple rewriting rules. For example, a sequence of Join-Swap transformations may put two retrieve operators on the same database together in the query tree and then Remote-Join-Eval would collapse the explicit join operator and the two retrieves into a single retrieval of a remote join. Cherniack & Zdonik (1996, 1998)
present more complex examples of this sort of programs of rewriting rules in the context of a query optimizer for object-oriented databases.

As we discussed in Sections 3.1.3 and 3.1.4 the language of the antecedent of the rewriting rules can be more expressive than conjunctive queries while still remaining computationally efficient.  For example, Figure 32 shows a rule from the manufacturing domain of Section 4.1 with a relationally-complete antecedent. This rule matches a subplan that contains a spray-paint operator, but does not contain either punch or drill-press operators that create holes of diameter smaller than 1 millimeter. In such case, the rule replaces the spray-paint operator by an immersion-paint operator. This rule would be useful in a situation in which painting by immersion could clog small holes.