
| (define (operator STACK)                   | (define (operator UNSTACK)               |
|--------------------------------------------|------------------------------------------|
| :parameters (?X ?Y ?Z)                     | :parameters (?X ?Y)                      |
| :precondition                              | :precondition                            |
| (:and (on ?X ?Z) (clear ?X) (clear ?Y)     | (:and (on ?X ?Y) (clear ?X) (:neq ?X ?Y) |
| (:neq ?Y ?Z) (:neq ?X ?Z) (:neq ?X ?Y)     | (:neq ?X Table) (:neq ?Y Table))         |
| (:neq ?X Table) (:neq ?Y Table))           | :effect (:and (on ?X Table) (clear ?Y)   |
| :effect (:and (on ?X ?Y) (:not (on ?X ?Z)) | (: not (on ?X ?Y))))                     |
| (clear ?Z) (:not (clear ?Y))))             |                                          |

Figure 2: Blocks World Operators
(define (operator PUNCH)
:parameters (?x ?width ?orientation)
:resources ((machine PUNCH) (is-object ?x))
: precondition (: and (is-object ?x)
(is-punchable ?x ?width ?orientation)
(has-clamp PUNCH))
:effect (:and (:forall (?surf) (:when (:neq ?surf ROUGH)
(:not (surface-condition ?x ?surf))))
(surf ace-condition ?x ROUGH)
(has-hole ?x ?width ?orientation)))
rough surface. 7 Note the specification on the resources slot. Declaring (machine PUNCH)
as a resource enforces that no other operator can use the punch concurrently. Similarly, declaring the part, (is-object ?x), as a resource means that only one operation at a time can be performed on the object. Further examples of operator specifications appear in Figures 18, 19, and 28.

A plan in PbR is represented by a graph, in the spirit of partial-order causal-link planners (POCL) such as UCPOP (Penberthy & Weld, 1992). The nodes are plan steps, that is, instantiated domain operators. The edges specify a temporal ordering relation among steps imposed by causal links and ordering constraints. A causal link is a record of how a proposition is established in a plan. This record contains the proposition (sometimes also called a condition), a producer step, and a consumer step. The producer is a step in the plan that asserts the proposition, that is, the proposition is one of its effects.  The consumer is a step that needs that proposition, that is, the proposition is one of its preconditions. By causality, the producer must precede the consumer.

The ordering constraints are needed to ensure that the plan is consistent. They arise from resolving operator threats and resource conflicts. An operator threat occurs when a step that negates the condition of a causal link can be ordered between the producer and the consumer steps of the causal link. To prevent this situation, which makes the plan inconsistent, POCL planners order the threatening step either before the producer (demotion)
or after the consumer (promotion) by posting the appropriate ordering constraints. For the